﻿-- -------------- create's----------------------

CREATE TABLE seleccion (
  nombre_seleccion varchar(25) NOT NULL PRIMARY KEY,
  director_tecnico varchar(35) NOT NULL,
  preparador_fisico varchar(35) NOT NULL
);

CREATE TABLE estadio (
  nombre varchar(25) NOT NULL PRIMARY KEY,
  capacidad INT NOT NULL,
  cantidad_butacas INT NOT NULL,
  cantidad_banderitas INT NOT NULL
);

CREATE TABLE jugador_de_seleccion (
  nombre varchar(35) NOT NULL PRIMARY KEY,
  posicion varchar(25) NOT NULL,
  posicion_auxiliar varchar(25) NOT NULL,
  edad INT,
  nombre_seleccion varchar(25) NOT NULL
);

CREATE TABLE partido (
  id_partido INT NOT NULL PRIMARY KEY,
  equipo_local varchar(25) NOT NULL,
  equipo_visitante varchar(25) NOT NULL,
  fecha DATE,
  nombre_arbitro varchar(35) NOT NULL,
  estadio varchar(25) NOT NULL,
  FOREIGN KEY (equipo_local) REFERENCES seleccion (nombre_seleccion),
  FOREIGN KEY (equipo_visitante) REFERENCES seleccion (nombre_seleccion),
  FOREIGN KEY (estadio) REFERENCES estadio (nombre)
);

CREATE TABLE gol (
  id_partido INT NOT NULL,
  nombre_goleador varchar(35) NOT NULL,
  minuto INT NOT NULL,
  PRIMARY KEY (id_partido, nombre_goleador, minuto),
  FOREIGN KEY (nombre_goleador) REFERENCES jugador_de_seleccion (nombre),
  FOREIGN KEY (id_partido) REFERENCES partido (id_partido)
);

CREATE TABLE tarjeta_amarilla (
  id_partido INT NOT NULL,
  nombre_amonestado varchar(35) NOT NULL,
  minuto INT NOT NULL,
  PRIMARY KEY (id_partido, nombre_amonestado, minuto),
  FOREIGN KEY (nombre_amonestado) REFERENCES jugador_de_seleccion (nombre),
  FOREIGN KEY (id_partido) REFERENCES partido (id_partido)
);

CREATE TABLE tarjeta_roja (
  id_partido INT NOT NULL,
  nombre_amonestado varchar(35) NOT NULL,
  minuto INT NOT NULL,
  PRIMARY KEY (id_partido, nombre_amonestado, minuto),
  FOREIGN KEY (nombre_amonestado) REFERENCES jugador_de_seleccion (nombre),
  FOREIGN KEY (id_partido) REFERENCES partido (id_partido)
);


-- -------------- seleccion ----------------------


INSERT INTO seleccion (nombreseleccion,directortecnico,preparadorfisico) 
VALUES 
('Argentina','Jorge Sampaoli','Alejandro Becacece'),
('Uruguay','Tanner Mcdaniel','Andrew Ward'),
('Paraguay','Garrison Keller','Joshua White'),
('Chile','Benjamin Farrell','Quentin Diaz'),
('Brasil','Igor Robertson','Brian Dennis'),
('Venezuela','Jonah Slater','Theodore Hopper'),
('Italia','Kadeem Ball','Kieran Crosby'),
('España','Salvador Perkins','Abel Mcgowan'),
('Inglaterra','Timothy Padilla','Bruno Garrison'),
('Iran','Zephania Sweet','Edward Burns');

INSERT INTO seleccion (nombreseleccion,directortecnico,preparadorfisico) 
VALUES 
('Estados Unidos','George Dyer','Cruz Schmidt'),
('Canada','Rooney Strickland','Zeph Shaffer'),
('Argelia','Rahim Finch','Devin Pruitt'),
('Angola','Dane Rose','Nash Fulton'),
('Antigua y Barbuda','Keane Horne','Samson Campbell'),
('Australia','Jesse Solis','Camden Keller'),
('Belgica','Emery David','Andrew Witt'),
('China','Orson Mcgee','Lane Gardner'),
('Corea del Norte','Akeem Beach','Kuame Stewart'),
('Japon','Jared Alexander','Ian Hood');


INSERT INTO seleccion (nombreseleccion,directortecnico,preparadorfisico) 
VALUES 
('Colombia','Baker Anderson','Driscoll Camacho'),
('Croacia','Acton Mooney','Ryan Galloway'),
('Costa Rica','Lucas Pennington','Randall Mcmillan'),
('Ecuador','Jeremy Cole','Abraham Lang'),
('Grecia','Hamilton Mason','Otto Gould'),
('Haiti','Nolan Leblanc','Jin Gibson'),
('Israel','Salvador Hudson','Talon Turner'),
('Lituania','Fuller Ratliff','Ivor Mann'),
('Kuwait','Arsenio Wagner','Boris Roberson'),
('Serbia','Dexter Mckenzie','Dieter Shields');


-- -------------- estadio ----------------------

INSERT INTO estadio (nombre,capacidad,cantidadbutacas,cantidadbanderitas) 
VALUES 
('MARACANA',200000,73531,44758),
('MINERAO',67695,31656,46444),
('SAN PABLO',69546,36238,40294),
('NACIONAL',47961,55858,24598),
('ARENA PANTANAL',43224,56784,22800),
('ARENA DA BAIXADA',40294,48418,17037),
('CASTELAO',64243,44072,48407),
('ARENA AMAZONIA',42406,48499,31674),
('DAS DUNAS',54222,43070,49471),
('BEIRA RIO',50363,58757,34486),
('ARENA PERNAMBUCO',42557,41209,47024),
('ARENA FONTE NOVA',52793,51748,36762);

-- -------------- jugadores de futbol ------------


INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion) 
VALUES 
('Marcelo Barovero','Arquero','Arquero',20,'Argentina'),
('Ramiro Funes Mori','Defensa','Defensa',22,'Argentina'),
('Nicolas Otamendi','Defensa','Defensa',24,'Argentina'),
('Gabriel Mercado','Defensa','Defensa',26,'Argentina'),
('Leonardo Ponzio','Volante','Volante',28,'Argentina'),
('Ariel Rojas','Volante','Volante',18,'Argentina'),
('Javier Mascherano','Volante','Volante',21,'Argentina'),
('Lucas Alario','Delantero','Delantero',30,'Argentina'),
('Mauro Icardi','Delantero','Delantero',36,'Argentina'),
('Lionel Messi','Delantero','Delantero',27,'Argentina');

INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion) 
VALUES 
('Joe Hart','Arquero','Arquero',20,'Inglaterra'),
('Chris Smalling','Defensa','Defensa',22,'Inglaterra'),
('John Terry','Defensa','Defensa',24,'Inglaterra'),
('Kyle Walker','Defensa','Defensa',26,'Inglaterra'),
('Delle Alli','Volante','Volante',28,'Inglaterra'),
('Harry Potter','Volante','Volante',30,'Inglaterra'),
('Fabian Delph','Volante','Volante',32,'Inglaterra'),
('Harry Keane','Delantero','Delantero',34,'Inglaterra'),
('Wayne Rooney','Delantero','Delantero',36,'Inglaterra'),
('Jamie Vardy','Delantero','Delantero',38,'Inglaterra');

INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion)
VALUES 
('Beau Hawkins','Arquero','Arquero',40,'Brasil'),
('Thiago Silva','Defensa','Defensa',42,'Brasil'),
('Filipe Luis','Defensa','Defensa',34,'Brasil'),
('Dani Alves','Defensa','Defensa',36,'Brasil'),
('Paulo Lima','Volante','Volante',38,'Brasil'),
('Felipe Melo','Volante','Volante',30,'Brasil'),
('Fernandinho','Volante','Volante',32,'Brasil'),
('Taison','Delantero','Delantero',34,'Brasil'),
('Juan Jesus','Delantero','Delantero',36,'Brasil'),
('Neymar','Delantero','Delantero',38,'Brasil');

INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion)
VALUES 
('Gianluigi Buffon','Arquero','Arquero',30,'Italia'),
('Andrea Barzagli','Defensa','Defensa',32,'Italia'),
('Giorgio Chiellini','Defensa','Defensa',34,'Italia'),
('Leandro Bonucci','Defensa','Defensa',36,'Italia'),
('Claudio Marchisio','Volante','Volante',38,'Italia'),
('Danielle De Rossi','Volante','Volante',30,'Italia'),
('Andrea Pirlo','Volante','Volante',32,'Italia'),
('Luca Toni','Delantero','Delantero',34,'Italia'),
('Alessandro Del Piero','Delantero','Delantero',36,'Italia'),
('Luca Rossi','Delantero','Delantero',38,'Italia');

INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion) 
VALUES 
('Martin Campaña','Arquero','Arquero',20,'Uruguay'),
('Diego Lugano','Defensa','Defensa',22,'Uruguay'),
('Sergio Polenta','Defensa','Defensa',24,'Uruguay'),
('Matias Corujo','Defensa','Defensa',23,'Uruguay'),
('Carlos Sanchez','Volante','Volante',25,'Uruguay'),
('Egidio Arevalo Rios','Volante','Volante',27,'Uruguay'),
('Tabare Viudez','Volante','Volante',29,'Uruguay'),
('Edinson Cavani','Delantero','Delantero',31,'Uruguay'),
('Luis Suarez','Delantero','Delantero',33,'Uruguay'),
('Ivan Alonso','Delantero','Delantero',35,'Uruguay');

INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion)
VALUES 
('Iker Casillas','Arquero','Arquero',39,'España'),
('Jordi Alba','Defensa','Defensa',37,'España'),
('Gerard Pique','Defensa','Defensa',21,'España'),
('Sergio Ramos','Defensa','Defensa',23,'España'),
('Sergi Busquets','Volante','Volante',25,'España'),
('David Silva','Volante','Volante',27,'España'),
('Jesus Navas','Volante','Volante',29,'España'),
('Fernando Llorente','Delantero','Delantero',31,'España'),
('Pedro','Delantero','Delantero',33,'España'),
('Diego Costa','Delantero','Delantero',35,'España');


INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion)
VALUES 
('Justo Villar','Arquero','Arquero',37,'Paraguay'),
('Jorge Moreira','Defensa','Defensa',39,'Paraguay'),
('Martin Perez','Defensa','Defensa',21,'Paraguay'),
('Edgardo Martin','Defensa','Defensa',22,'Paraguay'),
('Miguel Almiron','Volante','Volante',23,'Paraguay'),
('Nestor Ortigoza','Volante','Volante',24,'Paraguay'),
('Jorge Rojas','Volante','Volante',25,'Paraguay'),
('Oscar Cardozo','Delantero','Delantero',26,'Paraguay'),
('Nelson Haedo Valdez','Delantero','Delantero',27,'Paraguay'),
('Santiago Salcedo','Delantero','Delantero',28,'Paraguay');

INSERT INTO jugadordeseleccion (nombre,posicion,posicionauxiliar,edad,nombreseleccion)
VALUES 
('Ivan Tolasic','Arquero','Arquero',29,'Croacia'),
('Guy Gardner','Defensa','Defensa',30,'Croacia'),
('Daniel Mirkovic','Defensa','Defensa',31,'Croacia'),
('Mattias Kovacic','Defensa','Defensa',32,'Croacia'),
('John Kalinic','Volante','Volante',33,'Croacia'),
('Martin Perisic','Volante','Volante',34,'Croacia'),
('Ivan Rakitic','Volante','Volante',35,'Croacia'),
('Ivica Ollic','Delantero','Delantero',36,'Croacia'),
('Reuben Golasik','Delantero','Delantero',37,'Croacia'),
('Mario Mandzukic','Delantero','Delantero',38,'Croacia');

-- -------------- partido  ----------------------


INSERT INTO partido (idpartido,equipolocal,equipovisitante,fecha,nombrearbitro,estadio) 
VALUES 
(103240,'Argentina','Uruguay','2014-07-04','Berk Ray','MARACANA'),
(103241,'Argentina','Paraguay','2014-02-20','Alvin Burnett','MINERAO'),
(103242,'Argentina','Chile','2014-07-04','Cairo Potter','SAN PABLO'),
(103243,'Argentina','Inglaterra','2014-03-02','Rigel Medina','NACIONAL'),
(103244,'Argentina','España','2014-09-04','Brian Marks','ARENA PANTANAL'),
(103245,'Japon','Argentina','2014-05-02','Jin Simpson','ARENA DA BAIXADA'),
(103246,'Canada','Argentina','2014-12-12','Harper Shelton','CASTELAO'),
(103247,'Argelia','Argentina','2014-10-20','Lance Gillespie','BEIRA RIO'),
(103248,'Angola','Argentina','2014-09-01','Curran Rivera','DAS DUNAS'),
(103249,'Corea del Norte','Argentina','2014-12-26','Silas Schneider','ARENA FONTE NOVA');


INSERT INTO partido (idpartido,equipolocal,equipovisitante,fecha,nombrearbitro,estadio) 
VALUES 
(103250,'Italia','Australia','2014-10-23','Jarrod Fields','MARACANA'),
(103251,'Italia','Belgica','2014-12-18','Brendan Hickman','MINERAO'),
(103252,'Italia','Colombia','2014-07-02','Tyrone Mcdonald','SAN PABLO'),
(103253,'Italia','Croacia','2014-05-04','Thaddeus Vazquez','NACIONAL'),
(103254,'Italia','Iran','2014-12-07','Rigel Hughes','ARENA PANTANAL'),
(103255,'Costa Rica','Italia','2014-02-11','John Byrd','ARENA DA BAIXADA'),
(103256,'Ecuador','Italia','2014-04-06','Thomas Sanford','CASTELAO'),
(103257,'Grecia','Italia','2014-07-06','Damon Carpenter','BEIRA RIO'),
(103258,'Haiti','Italia','2014-01-29','Elton Perez','DAS DUNAS'),
(103259,'Israel','Italia','2014-09-26','Baker Pollard','ARENA FONTE NOVA');

INSERT INTO partido (idpartido,equipolocal,equipovisitante,fecha,nombrearbitro,estadio)
VALUES 
(103260,'Uruguay','Serbia','2014-10-09','Dieter Palmer','MARACANA'),
(103261,'Uruguay','Lituania','2014-08-08','Victor Jensen','MINERAO'),
(103262,'Uruguay','Kuwait','2014-08-24','Kennan Page','SAN PABLO'),
(103263,'Uruguay','Canada','2014-04-30','Tucker Wilcox','NACIONAL'),
(103264,'Uruguay','Argelia','2014-09-17','Matthew Rice','ARENA PANTANAL'),
(103265,'Angola','Uruguay','2014-02-07','Perry Guzman','ARENA DA BAIXADA'),
(103266,'Corea del Norte','Uruguay','2014-05-06','Kadeem Herrera','CASTELAO'),
(103267,'Paraguay','Uruguay', '2014-11-01','Dieter Estrada','BEIRA RIO'),
(103268,'Chile','Uruguay','2014-06-26','Arden Haynes','DAS DUNAS'),
(103269,'Italia','Uruguay','2014-02-20','Solomon Summers','ARENA FONTE NOVA');

INSERT INTO partido (idpartido,equipolocal,equipovisitante,fecha,nombrearbitro,estadio) 
VALUES 
(103270,'Inglaterra','Uruguay','2014-03-24','Mufutau Skinner','MARACANA'),
(103271,'Inglaterra','Italia','2014-07-10','Stephen Silva','MINERAO'),
(103272,'Inglaterra','Paraguay','2014-07-15','Dalton Rivera','SAN PABLO'),
(103273,'Inglaterra','Chile','2014-12-14','Richard Morton','NACIONAL'),
(103274,'Inglaterra','España','2014-04-16','Harlan Leblanc','ARENA PANTANAL'),
(103275,'Inglaterra','Japon','2014-08-14','Maxwell Kline','ARENA DA BAIXADA'),
(103276,'Canada','Inglaterra','2014-05-16','Zeus Gonzalez','CASTELAO'),
(103277,'Argelia','Inglaterra','2014-10-15','Forrest Douglas','BEIRA RIO'),
(103278,'Angola','Inglaterra','2014-01-16','Ali Mcdaniel','DAS DUNAS'),
(103279,'Corea del Norte','Inglaterra','2014-08-14','Connor Griffin','ARENA FONTE NOVA');

INSERT INTO partido (idpartido,equipolocal,equipovisitante,fecha,nombrearbitro,estadio) 
VALUES 
(103280,'España','Australia','2014-09-11','Xavier Bishop','MARACANA'),
(103281,'España','Belgica','2014-09-14','Dale Fields','MINERAO'),
(103282,'España','Colombia','2014-02-16','Zane Wagner','SAN PABLO'),
(103283,'España','Croacia','2014-09-12','Ray Barber','NACIONAL'),
(103284,'España','Paraguay','2014-09-14','Keith Waters','ARENA PANTANAL'),
(103285,'Chile','España','2014-02-16','Eagan Cox','ARENA DA BAIXADA'),
(103286,'Japon','España','2014-09-15','Russell Short','CASTELAO'),
(103287,'Angola','España','2014-09-10','Christian Russo','BEIRA RIO'),
(103288,'Lituania','España','2014-01-15','Herrod Carlson','DAS DUNAS'),
(103289,'Estados Unidos','España','2014-02-16','Lucian Oliver','ARENA FONTE NOVA');

INSERT INTO partido (idpartido,equipolocal,equipovisitante,fecha,nombrearbitro,estadio) 
VALUES 
(103290,'China','Estados Unidos','2014-06-21','Christopher Rivas','MARACANA'),
(103291,'China','Brasil','2014-10-06','Warren Chan','MINERAO'),
(103292,'China','Venezuela','2014-04-14','Dorian Barber','SAN PABLO'),
(103293,'China','Iran','2014-02-03','Elvis Norris','NACIONAL'),
(103294,'China','Canada','2014-01-13','Quentin Barlow','ARENA PANTANAL'),
(103295,'Argelia','China','2014-11-05','Vernon Hudson','ARENA DA BAIXADA'),
(103296,'Kuwait','China','2014-09-27','Evan Vargas','CASTELAO'),
(103297,'Belgica','China','2014-05-24','Jackson Hess','BEIRA RIO'),
(103298,'Lituania','China','2014-07-20','Reuben Collins','DAS DUNAS'),
(103299,'Costa Rica','China','2014-11-07','Kirk Mason','ARENA FONTE NOVA');

-- -------------- gol  ----------------------


INSERT INTO gol (idpartido,nombregoleador,minuto) 
VALUES 
(103240,'Marcelo Barovero','1'),
(103241,'Ramiro Funes Mori','2'),
(103242,'Nicolas Otamendi','3'),
(103243,'Gabriel Mercado','4'),
(103243,'Lionel Messi','23'),
(103243,'Lionel Messi','57'),
(103244,'Leonardo Ponzio','5'),
(103245,'Ariel Rojas','6'),
(103246,'Javier Mascherano','7'),
(103247,'Lucas Alario','8'),
(103248,'Mauro Icardi','9'),
(103249,'Lionel Messi','10'),
(103250,'Joe Hart','11'),
(103251,'Chris Smalling','12'),
(103251,'John Terry','13'),
(103251,'Kyle Walker','14'),
(103254,'Delle Alli','15'),
(103255,'Harry Potter','16'),
(103256,'Fabian Delph','17'),
(103257,'Harry Keane','18'),
(103258,'Wayne Rooney','19'),
(103259,'Jamie Vardy','20'),
(103260,'Beau Hawkins','21'),
(103261,'Thiago Silva','22'),
(103261,'Filipe Luis','23'),
(103263,'Dani Alves','24'),
(103264,'Paulo Lima'	,'25'),
(103265,'Felipe Melo','26'),
(103266,'Fernandinho','27'),
(103267,'Taison','28'),
(103268,'Juan Jesus','29');

INSERT INTO gol (idpartido,nombregoleador,minuto)
VALUES 
(103269,'Neymar','30'),
(103270,'Gianluigi Buffon','31'),
(103271,'Andrea Barzagli','32'),
(103272,'Giorgio Chiellini','33'),
(103273,'Leandro Bonucci','34'),
(103274,'Claudio Marchisio','35'),
(103277,'Danielle De Rossi','36'),
(103277,'Andrea Pirlo','37'),
(103277,'Luca Toni','38'),
(103278,'Alessandro Del Piero','39'),
(103279,'Luca Rossi','40'),
(103280,'Martin Campaña','41'),
(103281,'Diego Lugano','42'),
(103282,'Sergio Polenta','43'),
(103283,'Matias Corujo','44'),
(103284,'Carlos Sanchez','45'),
(103285,'Egidio Arevalo Rios','46'),
(103286,'Tabare Viudez','47'),
(103286,'Edinson Cavani','48'),
(103286,'Luis Suarez','49'),
(103289,'Ivan Alonso','50'),
(103290,'Iker Casillas','51'),
(103291,'Jordi Alba'	,'52'),
(103291,'Gerard Pique','53'),
(103293,'Sergio Ramos','54'),
(103294,'Sergi Busquets','55'),
(103295,'David Silva','56'),
(103296,'Jesus Navas','57');

INSERT INTO gol (idpartido,nombregoleador,minuto)
VALUES 
(103297,'Fernando Llorente','58'),
(103298,'Pedro','59'),
(103299,'Diego Costa','60'),
(103240,'Justo Villar','61'),
(103241,'Jorge Moreira','62'),
(103242,'Martin Perez','63'),
(103243,'Edgardo Martin','64'),
(103244,'Miguel Almiron','65'),
(103245,'Nestor Ortigoza','66'),
(103246,'Jorge Rojas','67'),
(103246,'Oscar Cardozo','68'),
(103246,'Nelson Haedo Valdez','69'),
(103250,'Santiago Salcedo','70'),
(103251,'Ivan Tolasic','71'),
(103252,'Guy Gardner','72'),
(103253,'Daniel Mirkovic','73'),
(103254,'Mattias Kovacic','74'),
(103255,'John Kalinic','75'),
(103256,'Martin Perisic','76'),
(103257,'Ivan Rakitic','77'),
(103257,'Ivica Ollic','78'),
(103259,'Reuben Golasik','79'),
(103260,'Mario Mandzukic','80'),
(103261,'Santiago Salcedo','81'),
(103262,'Ivan Tolasic','82'),
(103263,'Guy Gardner','83'),
(103264,'Daniel Mirkovic','84'),
(103265,'Mattias Kovacic','85'),
(103266,'John Kalinic','86'),
(103267,'Martin Perisic','87'),
(103268,'Ivan Rakitic','88'),
(103269,'Ivica Ollic','89'),
(103269,'Reuben Golasik','90'),
(103269,'Mario Mandzukic','1'),
(103269,'Luis Suarez','2'),
(103273,'Ivan Alonso','3'),
(103274,'Iker Casillas','4'),
(103275,'Jordi Alba','5'),
(103276,'Gerard Pique','6'),
(103277,'John Terry','7'),
(103278,'Kyle Walker','8'),
(103279,'Delle Alli','9');

-- -------------- tarjeta amarilla  ----------------------

INSERT INTO tarjetaamarilla (idpartido,nombreamonestado,minuto) 
VALUES 
(103251,'Kyle Walker','14'),
(103254,'Delle Alli','15'),
(103255,'Harry Potter','16'),
(103256,'Fabian Delph','17'),
(103257,'Harry Keane','18'),
(103257,'Wayne Rooney','19'),
(103259,'Jamie Vardy','20'),
(103259,'Luis Suarez','2'),
(103259,'Luis Suarez','43'),
(103240,'Ivan Alonso','3'),
(103241,'Iker Casillas','4'),
(103242,'Jordi Alba','5'),
(103243,'Gerard Pique','6'),
(103244,'John Terry','7'),
(103245,'Kyle Walker','8'),
(103246,'Delle Alli','9'),
(103277,'Danielle De Rossi','36'),
(103277,'Andrea Pirlo','37'),
(103277,'Luca Toni','38');

INSERT INTO tarjetaamarilla (idpartido,nombreamonestado,minuto) 
VALUES 
(103278,'Alessandro Del Piero','39'),
(103279,'Luca Rossi','40'),
(103280,'Martin Campaña','41'),
(103281,'Diego Lugano','12'),
(103281,'Diego Lugano','38'),
(103282,'Sergio Polenta','43'),
(103283,'Matias Corujo','44'),
(103284,'Carlos Sanchez','45'),
(103285,'Egidio Arevalo Rios','46'),
(103286,'Tabare Viudez','47'),
(103286,'Edinson Cavani','48'),
(103286,'Luis Suarez','49'),
(103289,'Ivan Alonso','50'),
(103289,'Ivan Alonso','63'),
(103290,'Iker Casillas','51'),
(103291,'Jordi Alba','17'),
(103291,'Jordi Alba','52'),
(103291,'Gerard Pique','53'),
(103293,'Sergio Ramos','54'),
(103294,'Sergi Busquets','55');


-- -------------- tarjeta roja  ----------------------


INSERT INTO tarjetaroja (idpartido,nombreamonestado,minuto)
VALUES 
(103240,'Iker Casillas','4'),
(103241,'Jordi Alba','5'),
(103242,'Gerard Pique','6'),
(103243,'John Terry','7'),
(103244,'Kyle Walker','8'),
(103245,'Delle Alli','9'),
(103277,'Danielle De Rossi'	,'36'),
(103277,'Andrea Pirlo','37'),
(103277,'Luca Toni','38'),
(103278,'Alessandro Del Piero','39'),
(103279,'Luca Rossi','40'),
(103280,'Martin Campaña','41'),
(103281,'Diego Lugano','42'),
(103282,'Sergio Polenta','43'),
(103283,'Matias Corujo','44'),
(103284,'Carlos Sanchez','45'),
(103285,'Egidio Arevalo Rios','46'),
(103286,'Tabare Viudez','47'),
(103241,'Ramiro Funes Mori','2'),
(103242,'Nicolas Otamendi','3'),
(103243,'Gabriel Mercado','4'),
(103244,'Leonardo Ponzio','5'),
(103245,'Ariel Rojas','6'),
(103246,'Luis Suarez','43'),
(103246,'Javier Mascherano','7'),
(103247,'Lucas Alario','8'),
(103248,'Mauro Icardi','9'),
(103249,'Lionel Messi','10'),
(103250,'Joe Hart','11'),
(103281,'Diego Lugano','38'),
(103251,'Chris Smalling','12'),
(103251,'John Terry','13'),
(103251,'Kyle Walker','14'),
(103254,'Delle Alli','15'),
(103255,'Harry Potter','16'),
(103296,'Jesus Navas','57'),
(103289,'Ivan Alonso','63'),
(103297,'Fernando Llorente','58'),
(103298,'Pedro','59'),
(103299,'Diego Costa','60'),
(103264,'Justo Villar','61'),
(103265,'Jorge Moreira','62'),
(103266,'Martin Perez','63'),
(103291,'Jordi Alba'	,'52'),
(103267,'Edgardo Martin','64'),
(103268,'Miguel Almiron','65');
