"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var COURSE = function COURSE() {
  if (!window.GBS_COURSE) window.GBS_COURSE = getParameterByName("course") || "";

  return window.GBS_COURSE;
};

var GitHubGuideLoader = function () {
  function GitHubGuideLoader(_ref) {
    var repo = _ref.repo,
        exercises = _ref.exercises;

    _classCallCheck(this, GitHubGuideLoader);

    this.repo = repo;
    this.exercises = exercises;
  }

  _createClass(GitHubGuideLoader, [{
    key: "getExercises",
    value: function getExercises() {
      var _this = this;

      return promisify(this.exercises.map(function (exercise) {
        return _.assign(exercise, {
          imageUrl: _this._makeImageUrl(exercise.path)
        });
      }));
    }
  }, {
    key: "_makeImageUrl",
    value: function _makeImageUrl(path) {
      return "https://raw.githubusercontent.com/" + this.repo + "/master/" + path + "/cover.png";
    }
  }], [{
    key: "all",
    value: function all() {
      return $.getJSON("https://raw.githubusercontent.com/" + COURSE() + "/master/guides.json");
    }
  }, {
    key: "makeUrlFor",
    value: function makeUrlFor(guide, exercise) {
      return "/" + window.GBS_PROJECT_TYPE + "?course=" + COURSE() + "&github=" + guide.repo + "&path=" + exercise.path;
    }
  }]);

  return GitHubGuideLoader;
}();

;