/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2017 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 5.19.0
 * @date    2018-07-11
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(this,function(){return function(e){function t(n){if(i[n])return i[n].exports;var o=i[n]={exports:{},id:n,loaded:!1};return e[n].call(o.exports,o,o.exports,t),o.loaded=!0,o.exports}var i={};return t.m=e,t.c=i,t.p="",t(0)}([function(e,t,i){"use strict";function n(e,t,i){if(!(this instanceof n))throw new Error('JSONEditor constructor called without "new".');var o=a.getInternetExplorerVersion();if(-1!=o&&o<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");if(t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t)){var r=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onEditable","onError","onModeChange","onSelectionChange","onTextSelectionChange","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","languages","language"];Object.keys(t).forEach(function(e){-1===r.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})}arguments.length&&this._create(e,t,i)}var o;try{o=i(!function(){var e=new Error('Cannot find module "ajv"');throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}var r=i(1),s=i(21),a=i(4);n.modes={},n.prototype.DEBOUNCE_INTERVAL=150,n.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},n.prototype.destroy=function(){},n.prototype.set=function(e){this.json=e},n.prototype.get=function(){return this.json},n.prototype.setText=function(e){this.json=a.parse(e)},n.prototype.getText=function(){return JSON.stringify(this.json)},n.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},n.prototype.getName=function(){return this.options&&this.options.name},n.prototype.setMode=function(e){var t,i,o=this.container,r=a.extend({},this.options),s=r.mode;r.mode=e;var l=n.modes[e];if(!l)throw new Error('Unknown mode "'+r.mode+'"');try{var c="text"==l.data;if(i=this.getName(),t=this[c?"getText":"get"](),this.destroy(),a.clear(this),a.extend(this,l.mixin),this.create(o,r),this.setName(i),this[c?"setText":"set"](t),"function"==typeof l.load)try{l.load.call(this)}catch(e){console.error(e)}if("function"==typeof r.onModeChange&&e!==s)try{r.onModeChange(e,s)}catch(e){console.error(e)}}catch(e){this._onError(e)}},n.prototype.getMode=function(){return this.options.mode},n.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},n.prototype.setSchema=function(e,t){if(e){var i;try{i=this.options.ajv||o({allErrors:!0,verbose:!0})}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},n.prototype.validate=function(){},n.prototype.refresh=function(){},n.registerMode=function(e){var t,i;if(a.isArray(e))for(t=0;t<e.length;t++)n.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var o=e.mode;if(o in n.modes)throw new Error('Mode "'+o+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var r=["setMode","registerMode","modes"];for(t=0;t<r.length;t++)if((i=r[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');n.modes[o]=e}},n.registerMode(r),n.registerMode(s),e.exports=n},function(e,t,i){"use strict";var n=i(2),o=i(3),r=i(6),s=i(7),a=i(9),l=i(10),c=i(19),h=i(4),d=i(20),u=i(15),p=i(17),f=i(8).translate,m=i(8).setLanguages,g=i(8).setLanguage,v=document.body,y={};y.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new n,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=new d(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new o(this)),this._createFrame(),this._createTable()},y.destroy=function(){this.frame&&this.container&&this.frame.parentNode==this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},y._setOptions=function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,onSelectionChange:null},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t]);this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=h.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),e.onSelectionChange&&this.onSelectionChange(e.onSelectionChange),m(this.options.languages),g(this.options.language)},y.set=function(e,t){if(t&&(console.warn('Second parameter "name" is deprecated. Use setName(name) instead.'),this.options.name=t),e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var i={field:this.options.name,value:e},n=new l(this,i);this._setRoot(n),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},y.get=function(){if(this.focusTarget){var e=l.getNodeFromTarget(this.focusTarget);e&&e.blur()}return this.node?this.node.getValue():void 0},y.getText=function(){return JSON.stringify(this.get())},y.setText=function(e){try{this.set(h.parse(e))}catch(i){var t=h.sanitize(e);this.set(h.parse(t))}},y.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},y.getName=function(){return this.options.name},y.focus=function(){var e=this.content.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},y.clear=function(){this.node&&(this.node.collapse(),this.tbody.removeChild(this.node.getDom()),delete this.node),this.treePath&&this.treePath.reset()},y._setRoot=function(e){this.clear(),this.node=e,this.tbody.appendChild(e.getDom())},y.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},y.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},y.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},y._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},y._onChange=function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}},y.validate=function(){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var e=this.node;if(e){var t=e.validate(),i=[];if(this.validateSchema){this.validateSchema(e.getValue())||(i=this.validateSchema.errors.map(function(e){return h.improveSchemaError(e)}).map(function(t){return{node:e.findNode(t.dataPath),error:t}}).filter(function(e){return null!=e.node}))}var n=t.concat(i),o=n.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=o.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(n).map(function(e){return e.node.setError(e.error,e.child),e.node})}},y.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},y.startAutoScroll=function(e){var t=this,i=this.content,n=h.getAbsoluteTop(i),o=i.clientHeight,r=n+o;e<n+24&&i.scrollTop>0?this.autoScrollStep=(n+24-e)/3:e>r-24&&o+i.scrollTop<i.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},y.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},y.setDomSelection=function(e){e&&("scrollTop"in e&&this.content&&(this.content.scrollTop=e.scrollTop),e.nodes&&this.select(e.nodes),e.range&&h.setSelectionOffset(e.range),e.dom&&e.dom.focus())},y.getDomSelection=function(){var e=h.getSelectionOffset();return e&&"DIV"!==e.container.nodeName&&(e=null),{dom:this.focusTarget,range:e,nodes:this.multiselection.nodes.slice(0),scrollTop:this.content?this.content.scrollTop:0}},y.scrollTo=function(e,t){var i=this.content;if(i){var n=this;n.animateTimeout&&(clearTimeout(n.animateTimeout),delete n.animateTimeout),n.animateCallback&&(n.animateCallback(!1),delete n.animateCallback);var o=i.clientHeight,r=i.scrollHeight-o,s=Math.min(Math.max(e-o/4,0),r),a=function(){var e=i.scrollTop,o=s-e;Math.abs(o)>3?(i.scrollTop+=o/3,n.animateCallback=t,n.animateTimeout=setTimeout(a,50)):(t&&t(!0),i.scrollTop=s,delete n.animateTimeout,delete n.animateCallback)};a()}else t&&t(!1)},y._createFrame=function(){function e(e){t._onEvent&&t._onEvent(e)}this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame);var t=this;this.frame.onclick=function(t){var i=t.target;e(t),"BUTTON"==i.nodeName&&t.preventDefault()},this.frame.oninput=e,this.frame.onchange=e,this.frame.onkeydown=e,this.frame.onkeyup=e,this.frame.oncut=e,this.frame.onpaste=e,this.frame.onmousedown=e,this.frame.onmouseup=e,this.frame.onmouseover=e,this.frame.onmouseout=e,h.addEventListener(this.frame,"focus",e,!0),h.addEventListener(this.frame,"blur",e,!0),this.frame.onfocusin=e,this.frame.onfocusout=e,this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var i=document.createElement("button");i.type="button",i.className="jsoneditor-expand-all",i.title=f("expandAll"),i.onclick=function(){t.expandAll()},this.menu.appendChild(i);var n=document.createElement("button");n.type="button",n.title=f("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n);var o=document.createElement("button");o.type="button",o.className="jsoneditor-sort",o.title=f("sortTitleShort"),o.onclick=function(){var e=t.options.modalAnchor||v;u(t.node,e)},this.menu.appendChild(o);var s=document.createElement("button");if(s.type="button",s.title=f("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){var e=t.options.modalAnchor||v;p(t.node,e)},this.menu.appendChild(s),this.history){var l=document.createElement("button");l.type="button",l.className="jsoneditor-undo jsoneditor-separator",l.title=f("undo"),l.onclick=function(){t._onUndo()},this.menu.appendChild(l),this.dom.undo=l;var d=document.createElement("button");d.type="button",d.className="jsoneditor-redo",d.title=f("redo"),d.onclick=function(){t._onRedo()},this.menu.appendChild(d),this.dom.redo=d,this.history.onChange=function(){l.disabled=!t.history.canUndo(),d.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var m=this;this.modeSwitcher=new c(this.menu,this.options.modes,this.options.mode,function(e){m.modeSwitcher.destroy(),m.setMode(e),m.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new r(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new a(this.navBar),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},y._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},y._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},y._onEvent=function(e){"keydown"===e.type&&this._onKeyDown(e),"focus"===e.type&&(this.focusTarget=e.target),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e);var t=l.getNodeFromTarget(e.target);if(t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var i=this;setTimeout(function(){i._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&l.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&(this.deselect(),t&&e.target===t.dom.drag?l.onDragStart(t,e):(!t||e.target!==t.dom.field&&e.target!==t.dom.value&&e.target!==t.dom.select)&&this._onMultiSelectStart(e));t&&t.onEvent(e)},y._updateTreePath=function(e){function t(e){return void 0!==e.field?e._escapeHTML(e.field):isNaN(e.index)?e.type:e.index}if(e&&e.length){h.removeClassName(this.navBar,"nav-bar-empty");var i=[];e.forEach(function(e){var n={name:t(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){n.children.push({name:t(e),node:e})}),i.push(n)}),this.treePath.setPath(i)}else h.addClassName(this.navBar,"nav-bar-empty")},y._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},y._onTreePathMenuItemSelected=function(e,t){if(e&&e.children.length){var i=e.children.find(function(e){return e.name===t});i&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus())}},y._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},y._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||this.dragDistanceEvent.dragDistance>10,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},y._onMultiSelectStart=function(e){var t=l.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=h.addEventListener(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=h.addEventListener(window,"mouseup",function(e){i._onMultiSelectEnd(e)}))}},y._onMultiSelect=function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=l.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;if(i&&n){if(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length){var o=this.multiselection.nodes[0];this.multiselection.start===o||this.multiselection.start.isDescendantOf(o)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},y._onMultiSelectEnd=function(e){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(h.removeEventListener(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(h.removeEventListener(window,"mouseup",this.mouseup),delete this.mouseup)},y.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},y.select=function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var i=this.getSelection();this._selectionChangedHandler(i.start,i.end)}}},y._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),o=0;o<i.length&&i[o]===n[o];)o++;var r=i[o-1],s=i[o],a=n[o];if(s&&a||(r.parent?(s=r,a=r,r=r.parent):(s=r.childs[0],a=r.childs[r.childs.length-1])),r&&s&&a){var l=r.childs.indexOf(s),c=r.childs.indexOf(a),h=Math.min(l,c),d=Math.max(l,c);return r.childs.slice(h,d+1)}return[]},y._onKeyDown=function(e){var t=e.which||e.keyCode,i=e.altKey,n=e.ctrlKey,o=e.metaKey,r=e.shiftKey,s=!1;if(9==t){var a=this;setTimeout(function(){h.selectContentEditable(a.focusTarget)},0)}if(this.searchBox)if(n&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114==t||n&&71==t){r?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}if(this.history&&(n&&!r&&90==t?(this._onUndo(),s=!0):n&&r&&90==t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&!(n||i||o||1!=e.key.length&&8!=t&&46!=t)){s=!1;var c="";e.target.className.indexOf("jsoneditor-value")>=0&&(c="value"),e.target.className.indexOf("jsoneditor-field")>=0&&(c="field");var d=l.getNodeFromTarget(e.target);setTimeout(function(e,t){if(t.innerText.length>0){var i=this.options.autocomplete.getOptions(t.innerText,e.getPath(),c,e.editor);null===i?this.autocomplete.hideDropDown():"function"==typeof i.then?i.then(function(e){null===e?this.autocomplete.hideDropDown():e.options?this.autocomplete.show(t,e.startFrom,e.options):this.autocomplete.show(t,0,e)}.bind(this)):i.options?this.autocomplete.show(t,i.startFrom,i.options):this.autocomplete.show(t,0,i)}else this.autocomplete.hideDropDown()}.bind(this,d,e.target),50)}s&&(e.preventDefault(),e.stopPropagation())},y._createTable=function(){var e=document.createElement("div");e.className="jsoneditor-outer",this.options.navigationBar&&h.addClassName(e,"has-nav-bar"),this.contentOuter=e,this.content=document.createElement("div"),this.content.className="jsoneditor-tree",e.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table);var t;this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&(t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t)),t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t),t=document.createElement("col"),this.colgroupContent.appendChild(t),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(e)},y.showContextMenu=function(e,t){var i=[],n=this;i.push({text:f("duplicateText"),title:f("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){l.onDuplicate(n.multiselection.nodes)}}),i.push({text:f("remove"),title:f("removeTitle"),className:"jsoneditor-remove",click:function(){l.onRemove(n.multiselection.nodes)}}),new s(i,{close:t}).show(e,this.content)},y.getSelection=function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],i=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=i.serialize()):(e.start=i.serialize(),e.end=t.serialize())}return e},y.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=h.debounce(e,this.DEBOUNCE_INTERVAL))},y.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is depracated and should not be used, see documantaion for supported selection options"),this.setDomSelection(e));var i=this._getNodeIntsncesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},y._getNodeIntsncesByRange=function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var o=[];if(i instanceof l)if(n instanceof l&&n!==i)if(i.parent===n.parent){var e,t;i.getIndex()<n.getIndex()?(e=i,t=n):(e=n,t=i);var r=e;o.push(r);do{r=r.nextSibling(),o.push(r)}while(r&&r!==t)}else o=this._findTopLevelNodes(i,n);else o.push(i);return o},y.getNodesByRange=function(e,t){var i=this._getNodeIntsncesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n},e.exports=[{mode:"tree",mixin:y,data:"json"},{mode:"view",mixin:y,data:"json"},{mode:"form",mixin:y,data:"json"}]},function(e,t){"use strict";function i(){this.locked=!1}i.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},i.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},i.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},i.prototype.lock=function(){this.locked=!0},i.prototype.unlock=function(){this.locked=!1},e.exports=i},function(e,t,i){"use strict";function n(e){this.editor=e,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){e.node.updateField(e.oldValue)},redo:function(e){e.node.updateField(e.newValue)}},editValue:{undo:function(e){e.node.updateValue(e.oldValue)},redo:function(e){e.node.updateValue(e.newValue)}},changeType:{undo:function(e){e.node.changeType(e.oldType)},redo:function(e){e.node.changeType(e.newType)}},appendNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){e.nodes.forEach(function(t){e.parent.appendChild(t)})}},insertBeforeNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){e.nodes.forEach(function(t){e.parent.insertBefore(t,e.beforeNode)})}},insertAfterNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){var t=e.afterNode;e.nodes.forEach(function(i){e.parent.insertAfter(e.node,t),t=i})}},removeNodes:{undo:function(e){var t=e.parent,i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})}},duplicateNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){var t=e.afterNode;e.nodes.forEach(function(i){e.parent.insertAfter(i,t),t=i})}},moveNodes:{undo:function(e){e.nodes.forEach(function(t){e.oldBeforeNode.parent.moveBefore(t,e.oldBeforeNode)})},redo:function(e){e.nodes.forEach(function(t){e.newBeforeNode.parent.moveBefore(t,e.newBeforeNode)})}},sort:{undo:function(e){var t=e.node;t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=e.node;t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){e.node.setValue(e.oldValue)},redo:function(e){e.node.setValue(e.newValue)}}}}i(4);n.prototype.onChange=function(){},n.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},n.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},n.prototype.canUndo=function(){return this.index>=0},n.prototype.canRedo=function(){return this.index<this.history.length-1},n.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.undo?(t.undo(e.params),e.params.oldSelection&&this.editor.setDomSelection(e.params.oldSelection)):console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}},n.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.redo?(t.redo(e.params),e.params.newSelection&&this.editor.setDomSelection(e.params.newSelection)):console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}},n.prototype.destroy=function(){this.editor=null,this.history=[],this.index=-1},e.exports=n},function(e,t,i){"use strict";var n=i(5);t.parse=function(e){try{return JSON.parse(e)}catch(i){throw t.validate(e),i}},t.sanitize=function(e){function t(){return e.charAt(s)}function i(){return e.charAt(s+1)}function n(){return e.charAt(s-1)}function o(i){r.push('"'),s++;for(var o=t();s<e.length&&o!==i;)'"'===o&&"\\"!==n()?r.push('\\"'):l.hasOwnProperty(o)?r.push(l[o]):"\\"===o?(s++,o=t(),"'"!==o&&r.push("\\"),r.push(o)):r.push(o),s++,o=t();o===i&&(r.push('"'),s++)}var r=[],s=0,a=e.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);a&&(e=a[3]);for(var l={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};s<e.length;){var c=t();"/"===c&&"*"===i()?function(){for(s+=2;s<e.length&&("*"!==t()||"/"!==i());)s++;s+=2}():"/"===c&&"/"===i()?function(){for(s+=2;s<e.length&&"\n"!==t();)s++}():" "===c||c>=" "&&c<=" "||" "===c||" "===c||"　"===c?(r.push(" "),s++):"'"===c?o("'"):'"'===c?o('"'):"`"===c?o("´"):"‘"===c?o("’"):"“"===c?o("”"):/[a-zA-Z_$]/.test(c)&&-1!==["{",","].indexOf(function(){for(var e=r.length-1;e>=0;){var t=r[e];if(" "!==t&&"\n"!==t&&"\r"!==t&&"\t"!==t)return t;e--}return""}())?function(){for(var e=["null","true","false"],i="",n=t(),o=/[a-zA-Z_$\d]/;o.test(n);)i+=n,s++,n=t();-1===e.indexOf(i)?r.push('"'+i+'"'):r.push(i)}():(r.push(c),s++)}return r.join("")},t.escapeUnicodeChars=function(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})},t.validate=function(e){void 0!==n?n.parse(e):JSON.parse(e)},t.extend=function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},t.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},t.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":t.isArray(e)?"array":"object"};var o=/^https?:\/\/\S+$/;t.isUrl=function(e){return("string"==typeof e||e instanceof String)&&o.test(e)},t.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},t.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0},t.getAbsoluteTop=function(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0},t.addClassName=function(e,t){var i=e.className.split(" ");-1==i.indexOf(t)&&(i.push(t),e.className=i.join(" "))},t.removeClassName=function(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!=n&&(i.splice(n,1),e.className=i.join(" "))},t.stripFormatting=function(e){for(var i=e.childNodes,n=0,o=i.length;n<o;n++){var r=i[n];r.style&&r.removeAttribute("style");var s=r.attributes;if(s)for(var a=s.length-1;a>=0;a--){var l=s[a];!0===l.specified&&r.removeAttribute(l.name)}t.stripFormatting(r)}},t.setEndOfContentEditable=function(e){var t,i;document.createRange&&(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),i=window.getSelection(),i.removeAllRanges(),i.addRange(t))},t.selectContentEditable=function(e){if(e&&"DIV"==e.nodeName){var t,i;window.getSelection&&document.createRange&&(i=document.createRange(),i.selectNodeContents(e),t=window.getSelection(),t.removeAllRanges(),t.addRange(i))}},t.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},t.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},t.getSelectionOffset=function(){var e=t.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},t.setSelectionOffset=function(e){if(document.createRange&&window.getSelection){if(window.getSelection()){var i=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),i.setStart(e.container.firstChild,e.startOffset),i.setEnd(e.container.firstChild,e.endOffset),t.setSelection(i)}}},t.getInnerText=function(e,i){if(void 0==i&&(i={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return i.flush()+e.nodeValue;if(e.hasChildNodes()){for(var n=e.childNodes,o="",r=0,s=n.length;r<s;r++){var a=n[r];if("DIV"==a.nodeName||"P"==a.nodeName){var l=n[r-1],c=l?l.nodeName:void 0;c&&"DIV"!=c&&"P"!=c&&"BR"!=c&&(o+="\n",i.flush()),o+=t.getInnerText(a,i),i.set("\n")}else"BR"==a.nodeName?(o+=i.flush(),i.set("\n")):o+=t.getInnerText(a,i)}return o}return"P"==e.nodeName&&-1!=t.getInternetExplorerVersion()?i.flush():""},t.getInternetExplorerVersion=function(){if(-1==r){var e=-1;if("undefined"!=typeof navigator&&"Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}r=e}return r},t.isFirefox=function(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")};var r=-1;t.addEventListener=function(e,i,n,o){if(e.addEventListener)return void 0===o&&(o=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.addEventListener(i,n,o),n;if(e.attachEvent){var r=function(){return n.call(e,window.event)};return e.attachEvent("on"+i,r),r}},t.removeEventListener=function(e,i,n,o){e.removeEventListener?(void 0===o&&(o=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.removeEventListener(i,n,o)):e.detachEvent&&e.detachEvent("on"+i,n)},t.parsePath=function e(t){var i,n;if(0===t.length)return[];var o=t.match(/^\.(\w+)/);if(o)i=o[1],n=t.substr(i.length+1);else{if("["!==t[0])throw new SyntaxError("Failed to parse path");var r=t.indexOf("]");if(-1===r)throw new SyntaxError("Character ] expected in path");if(1===r)throw new SyntaxError("Index expected after [");var s=t.substring(1,r);"'"===s[0]&&(s='"'+s.substring(1,s.length-1)+'"'),i="*"===s?s:JSON.parse(s),n=t.substr(r+1)}return[i].concat(e(n))},t.improveSchemaError=function(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(t=t.map(function(e){return JSON.stringify(e)}),t.length>5){var i=["("+(t.length-5)+" more...)"];t=t.slice(0,5),t.push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e},t.insideRect=function(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom},t.debounce=function(e,t,i){var n;return function(){var o=this,r=arguments,s=function(){n=null,i||e.apply(o,r)},a=i&&!n;clearTimeout(n),n=setTimeout(s,t),a&&e.apply(o,r)}},t.textDiff=function(e,t){for(var i=t.length,n=0,o=e.length,r=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(r-1)===e.charAt(o-1)&&r>n&&o>0;)r--,o--;return{start:n,end:r}},t.getInputSelection=function(e){function t(t){var i=e.value.substring(0,t);return{row:(i.match(/\n/g)||[]).length+1,column:i.length-i.lastIndexOf("\n")}}var i,n,o,r,s,a=0,l=0;return"number"==typeof e.selectionStart&&"number"==typeof e.selectionEnd?(a=e.selectionStart,l=e.selectionEnd):(n=document.selection.createRange())&&n.parentElement()==e&&(r=e.value.length,i=e.value.replace(/\r\n/g,"\n"),o=e.createTextRange(),o.moveToBookmark(n.getBookmark()),s=e.createTextRange(),s.collapse(!1),o.compareEndPoints("StartToEnd",s)>-1?a=l=r:(a=-o.moveStart("character",-r),a+=i.slice(0,a).split("\n").length-1,o.compareEndPoints("EndToEnd",s)>-1?l=r:(l=-o.moveEnd("character",-r),l+=i.slice(0,l).split("\n").length-1))),{startIndex:a,endIndex:l,start:t(a),end:t(l)}},t.getIndexForPosition=function(e,t,i){var n=e.value||"";if(t>0&&i>0){var o=n.split("\n",t);t=Math.min(o.length,t),i=Math.min(o[t-1].length,i-1);var r=1==t?i:i+1;return o.slice(0,t-1).join("\n").length+r}return-1},"undefined"!=typeof Element&&function(){function e(e){e.hasOwnProperty("remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){null!=this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&e(Element.prototype),"undefined"!=typeof CharacterData&&e(CharacterData.prototype),"undefined"!=typeof DocumentType&&e(DocumentType.prototype)}(),String.prototype.startsWith||(String.prototype.startsWith=function(e,t){return t=t||0,this.substr(t,e.length)===e}),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return i}})},function(e,t,i){var n=function(){var e={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,o,r,s){var a=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[a-1];case 13:this.$={};break;case 14:this.$=r[a-1];break;case 15:this.$=[r[a-2],r[a]];break;case 16:this.$={},this.$[r[a][0]]=r[a][1];break;case 17:this.$=r[a-2],r[a-2][r[a][0]]=r[a][1];break;case 18:this.$=[];break;case 19:this.$=r[a-1];break;case 20:this.$=[r[a]];break;case 21:this.$=r[a-2],r[a-2].push(r[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){function t(){var e;return e=i.lexer.lex()||1,"number"!=typeof e&&(e=i.symbols_[e]||e),e}var i=this,n=[0],o=[null],r=[],s=this.table,a="",l=0,c=0,h=0,d=2;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var u=this.lexer.yylloc;r.push(u),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var p,f,m,g,v,y,b,x,w,_={};;){if(m=n[n.length-1],this.defaultActions[m]?g=this.defaultActions[m]:(null==p&&(p=t()),g=s[m]&&s[m][p]),void 0===g||!g.length||!g[0]){if(!h){w=[];for(y in s[m])this.terminals_[y]&&y>2&&w.push("'"+this.terminals_[y]+"'");var C="";C=this.lexer.showPosition?"Parse error on line "+(l+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+w.join(", ")+", got '"+this.terminals_[p]+"'":"Parse error on line "+(l+1)+": Unexpected "+(1==p?"end of input":"'"+(this.terminals_[p]||p)+"'"),this.parseError(C,{text:this.lexer.match,token:this.terminals_[p]||p,line:this.lexer.yylineno,loc:u,expected:w})}if(3==h){if(1==p)throw new Error(C||"Parsing halted.");c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,p=t()}for(;;){if(d.toString()in s[m])break;if(0==m)throw new Error(C||"Parsing halted.");!function(e){n.length=n.length-2*e,o.length=o.length-e,r.length=r.length-e}(1),m=n[n.length-1]}f=p,p=d,m=n[n.length-1],g=s[m]&&s[m][d],h=3}if(g[0]instanceof Array&&g.length>1)throw new Error("Parse Error: multiple actions possible at state: "+m+", token: "+p);switch(g[0]){case 1:n.push(p),o.push(this.lexer.yytext),r.push(this.lexer.yylloc),n.push(g[1]),p=null,f?(p=f,f=null):(c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,h>0&&h--);break;case 2:if(b=this.productions_[g[1]][1],_.$=o[o.length-b],_._$={first_line:r[r.length-(b||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(b||1)].first_column,last_column:r[r.length-1].last_column},void 0!==(v=this.performAction.call(_,a,c,l,this.yy,g[1],o,r)))return v;b&&(n=n.slice(0,-1*b*2),o=o.slice(0,-1*b),r=r.slice(0,-1*b)),n.push(this.productions_[g[1]][0]),o.push(_.$),r.push(_._$),x=s[n[n.length-2]][n[n.length-1]],n.push(x);break;case 3:return!0}}return!0}},t=function(){var e={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(e.length>20?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(e.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0);var e,t,i,n,o;this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),s=0;s<r.length&&(!(i=this._input.match(this.rules[r[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?(o=t[0].match(/\n.*/g),o&&(this.yylineno+=o.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:o?o[o.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,r[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)}};return e.options={},e.performAction=function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},e.rules=[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt\/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],e.conditions={INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}},e}();return e.lexer=t,e}();t.parser=n,t.parse=n.parse.bind(n)},function(e,t){"use strict";function i(e,t){var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var n=document.createElement("table");this.dom.table=n,n.className="jsoneditor-search",t.appendChild(n);var o=document.createElement("tbody");this.dom.tbody=o,n.appendChild(o);var r=document.createElement("tr");o.appendChild(r);var s=document.createElement("td");r.appendChild(s);var a=document.createElement("div");this.dom.results=a,a.className="jsoneditor-results",s.appendChild(a),s=document.createElement("td"),r.appendChild(s);var l=document.createElement("div");this.dom.input=l,l.className="jsoneditor-frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var h=document.createElement("tbody");c.appendChild(h),r=document.createElement("tr"),h.appendChild(r);var d=document.createElement("button");d.type="button",d.className="jsoneditor-refresh",s=document.createElement("td"),s.appendChild(d),r.appendChild(s);var u=document.createElement("input");this.dom.search=u,u.oninput=function(e){i._onDelayedSearch(e)},u.onchange=function(e){i._onSearch()},u.onkeydown=function(e){i._onKeyDown(e)},u.onkeyup=function(e){i._onKeyUp(e)},d.onclick=function(e){u.select()},s=document.createElement("td"),s.appendChild(u),r.appendChild(s);var p=document.createElement("button");p.type="button",p.title="Next result (Enter)",p.className="jsoneditor-next",p.onclick=function(){i.next()},s=document.createElement("td"),s.appendChild(p),r.appendChild(s);var f=document.createElement("button");f.type="button",f.title="Previous result (Shift+Enter)",f.className="jsoneditor-previous",f.onclick=function(){i.previous()},s=document.createElement("td"),s.appendChild(f),r.appendChild(s)}i.prototype.next=function(e){if(void 0!=this.results){var t=void 0!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},i.prototype.previous=function(e){if(void 0!=this.results){var t=this.results.length-1,i=void 0!=this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}},i.prototype._setActiveResult=function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"==this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,o=this.results[this.resultIndex].elem;"field"==o?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(o)})},i.prototype._clearDelay=function(){void 0!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},i.prototype._onDelayedSearch=function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)},i.prototype._onSearch=function(e){this._clearDelay();var t=this.dom.search.value,i=t.length>0?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0;if(this._setActiveResult(0,!1),void 0!==i){var o=this.results.length;this.dom.results.innerHTML=0===o?"no&nbsp;results":1===o?"1&nbsp;result":o>n?n+"+&nbsp;results":o+"&nbsp;results"}else this.dom.results.innerHTML=""}},i.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},i.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},i.prototype.clear=function(){this.dom.search.value="",this._onSearch()},i.prototype.destroy=function(){this.editor=null,this.dom.container.removeChild(this.dom.table),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()},e.exports=i},function(e,t,i){"use strict";function n(e){return e.getRootNode&&e.getRootNode()||window}function o(e,t){function i(e,t,o){o.forEach(function(o){if("separator"==o.type){var r=document.createElement("div");r.className="jsoneditor-separator",l=document.createElement("li"),l.appendChild(r),e.appendChild(l)}else{var a={},l=document.createElement("li");e.appendChild(l);var c=document.createElement("button");if(c.type="button",c.className=o.className,a.button=c,o.title&&(c.title=o.title),o.click&&(c.onclick=function(e){e.preventDefault(),n.hide(),o.click()}),l.appendChild(c),o.submenu){var h=document.createElement("div");h.className="jsoneditor-icon",c.appendChild(h);var d=document.createElement("div");d.className="jsoneditor-text"+(o.click?"":" jsoneditor-right-margin"),d.appendChild(document.createTextNode(o.text)),c.appendChild(d);var u;if(o.click){c.className+=" jsoneditor-default";var p=document.createElement("button");p.type="button",a.buttonExpand=p,p.className="jsoneditor-expand",p.innerHTML='<div class="jsoneditor-expand"></div>',l.appendChild(p),o.submenuTitle&&(p.title=o.submenuTitle),u=p}else{var f=document.createElement("div");f.className="jsoneditor-expand",c.appendChild(f),u=c}u.onclick=function(e){e.preventDefault(),n._onExpandItem(a),u.focus()};var m=[];a.subItems=m;var g=document.createElement("ul");a.ul=g,g.className="jsoneditor-menu",g.style.height="0",l.appendChild(g),i(g,m,o.submenu)}else c.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+s(o.text)+"</div>";t.push(a)}})}this.dom={};var n=this,o=this.dom;this.anchor=void 0,this.items=e,this.eventListeners={},this.selection=void 0,this.onClose=t?t.close:void 0;var r=document.createElement("div");r.className="jsoneditor-contextmenu-root",o.root=r;var a=document.createElement("div");a.className="jsoneditor-contextmenu",o.menu=a,r.appendChild(a);var l=document.createElement("ul");l.className="jsoneditor-menu",a.appendChild(l),o.list=l,o.items=[];var c=document.createElement("button");c.type="button",o.focusButton=c;var h=document.createElement("li");h.style.overflow="hidden",h.style.height="0",h.appendChild(c),l.appendChild(h),i(l,this.dom.items,e),this.maxHeight=0,e.forEach(function(t){var i=24*(e.length+(t.submenu?t.submenu.length:0));n.maxHeight=Math.max(n.maxHeight,i)})}var r=i(4),s=i(8).translate;o.prototype._getVisibleButtons=function(){var e=[],t=this;return this.dom.items.forEach(function(i){e.push(i.button),i.buttonExpand&&e.push(i.buttonExpand),i.subItems&&i==t.expandedItem&&i.subItems.forEach(function(t){e.push(t.button),t.buttonExpand&&e.push(t.buttonExpand)})}),e},o.visibleMenu=void 0,o.prototype.show=function(e,t){this.hide();var i=!0,s=e.parentNode,a=e.getBoundingClientRect(),l=s.getBoundingClientRect();if(t){var c=t.getBoundingClientRect();a.bottom+this.maxHeight<c.bottom||a.top-this.maxHeight>c.top&&(i=!1)}var h=a.left-l.left,d=a.top-l.top;if(i){var u=e.offsetHeight;this.dom.menu.style.left=h+"px",this.dom.menu.style.top=d+u+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left=h+"px",this.dom.menu.style.top=d+"px",this.dom.menu.style.bottom="0px";this.rootNode=n(e),s.insertBefore(this.dom.root,s.firstChild);var p=this,f=this.dom.list;this.eventListeners.mousedown=r.addEventListener(this.rootNode,"mousedown",function(e){var t=e.target;t==f||p._isChildOf(t,f)||(p.hide(),e.stopPropagation(),e.preventDefault())}),this.eventListeners.keydown=r.addEventListener(this.rootNode,"keydown",function(e){p._onKeyDown(e)}),this.selection=r.getSelection(),this.anchor=e,setTimeout(function(){p.dom.focusButton.focus()},0),o.visibleMenu&&o.visibleMenu.hide(),o.visibleMenu=this},o.prototype.hide=function(){this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose());for(var e in this.eventListeners)if(this.eventListeners.hasOwnProperty(e)){var t=this.eventListeners[e];t&&r.removeEventListener(this.rootNode,e,t),delete this.eventListeners[e]}o.visibleMenu==this&&(o.visibleMenu=void 0)},o.prototype._onExpandItem=function(e){var t=this,i=e==this.expandedItem,n=this.expandedItem;if(n&&(n.ul.style.height="0",n.ul.style.padding="",setTimeout(function(){t.expandedItem!=n&&(n.ul.style.display="",r.removeClassName(n.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!i){var o=e.ul;o.style.display="block";o.clientHeight;setTimeout(function(){if(t.expandedItem==e){for(var i=0,n=0;n<o.childNodes.length;n++)i+=o.childNodes[n].clientHeight;o.style.height=i+"px",o.style.padding="5px 10px"}},0),r.addClassName(o.parentNode,"jsoneditor-selected"),this.expandedItem=e}},o.prototype._onKeyDown=function(e){var t,i,n,o,s=e.target,a=e.which,l=!1;27==a?(this.selection&&r.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),l=!0):9==a?e.shiftKey?(t=this._getVisibleButtons(),0==(i=t.indexOf(s))&&(t[t.length-1].focus(),l=!0)):(t=this._getVisibleButtons(),(i=t.indexOf(s))==t.length-1&&(t[0].focus(),l=!0)):37==a?("jsoneditor-expand"==s.className&&(t=this._getVisibleButtons(),i=t.indexOf(s),(n=t[i-1])&&n.focus()),l=!0):38==a?(t=this._getVisibleButtons(),i=t.indexOf(s),n=t[i-1],n&&"jsoneditor-expand"==n.className&&(n=t[i-2]),n||(n=t[t.length-1]),n&&n.focus(),l=!0):39==a?(t=this._getVisibleButtons(),i=t.indexOf(s),o=t[i+1],o&&"jsoneditor-expand"==o.className&&o.focus(),l=!0):40==a&&(t=this._getVisibleButtons(),i=t.indexOf(s),o=t[i+1],o&&"jsoneditor-expand"==o.className&&(o=t[i+2]),o||(o=t[0]),o&&(o.focus(),l=!0),l=!0),l&&(e.stopPropagation(),e.preventDefault())},o.prototype._isChildOf=function(e,t){for(var i=e.parentNode;i;){if(i==t)return!0;i=i.parentNode}return!1},e.exports=o},function(e,t){"use strict";var i,n=["en","pt-BR"],o={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.'},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Select a node...",showAll:"mostre tudo",showMore:"mostre mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"Texto",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.'}},r="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0;i=n.find(function(e){return e===r}),i||(i="en"),e.exports={_locales:n,_defs:o,_lang:i,setLanguage:function(e){if(e){var t=n.find(function(t){return t===e});t?i=t:console.error("Language not found")}},setLanguages:function(e){if(e)for(var t in e){var i=n.find(function(e){return e===t});i||n.push(t),o[t]=Object.assign({},o.en,o[t],e[t])}},translate:function(e,t,n){n||(n=i);var r=o[n][e];if(t)for(e in t)r=r.replace("${"+e+"}",t[e]);return r||e}}},function(e,t,i){"use strict";function n(e){e&&(this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",e.appendChild(this.path),this.reset())}var o=i(7),r=i(8).translate;n.prototype.reset=function(){this.path.innerHTML=r("selectNode")},n.prototype.setPath=function(e){function t(e){this.selectionCallback&&this.selectionCallback(e)}function i(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}var n=this;this.path.innerHTML="",e&&e.length&&e.forEach(function(r,s){var a,l=document.createElement("span");if(l.className="jsoneditor-treepath-element",l.innerText=r.name,l.onclick=t.bind(n,r),n.path.appendChild(l),r.children.length&&(a=document.createElement("span"),a.className="jsoneditor-treepath-seperator",a.innerHTML="&#9658;",a.onclick=function(){var t=[];r.children.forEach(function(o){t.push({text:o.name,className:"jsoneditor-type-modes"+(e[s+1]+1&&e[s+1].name===o.name?" jsoneditor-selected":""),click:i.bind(n,r,o.name)})}),new o(t).show(a)},n.path.appendChild(a,n.container)),s===e.length-1){var c=(a||l).getBoundingClientRect().left;n.path.offsetWidth<c&&(n.path.scrollLeft=c)}})},n.prototype.onSectionSelected=function(e){"function"==typeof e&&(this.selectionCallback=e)},n.prototype.onContextMenuItemSelected=function(e){"function"==typeof e&&(this.contextMenuCallback=e)},e.exports=n},function(e,t,i){"use strict";function n(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),this.setValue(t.value,t.type)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=d.debounce(this._onChangeValue.bind(this),n.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=d.debounce(this._onChangeField.bind(this),n.prototype.DEBOUNCE_INTERVAL)}var o=i(11),r=i(12),s=i(7),a=i(13),l=i(14),c=i(15),h=i(17),d=i(4),u=i(8).translate,p=document.body;n.prototype.DEBOUNCE_INTERVAL=150,n.prototype.MAX_SEARCH_RESULTS=999,n.prototype.MAX_VISIBLE_CHILDS=100,n.prototype.visibleChilds=n.prototype.MAX_VISIBLE_CHILDS,n.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},n.prototype.getPath=function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t},n.prototype.getName=function(){return this.parent?"array"!=this.parent.type?this.field:this.index:void 0},n.prototype.findNodeByPath=function(e){if(e){if(0==e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}},n.prototype.serialize=function(){return{value:this.getValue(),path:this.getPath()}},n.prototype.findNode=function(e){for(var t=d.parsePath(e),i=this;i&&t.length>0;){var n=t.shift();if("number"==typeof n){if("array"!==i.type)throw new Error("Cannot get child node at index "+n+": node is no array");i=i.childs[n]}else{if("object"!==i.type)throw new Error("Cannot get child node "+n+": node is no object");i=i.childs.filter(function(e){return e.field===n})[0]}}return i},n.prototype.findParents=function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e},n.prototype.setError=function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()},n.prototype.updateError=function(){var e=this.error,t=this.dom.tdError;if(e&&this.dom&&this.dom.tr){t||(t=document.createElement("td"),this.dom.tdError=t,this.dom.tdValue.parentNode.appendChild(t));var i=document.createElement("div");i.className="jsoneditor-popover jsoneditor-right",i.appendChild(document.createTextNode(e.message));var n=document.createElement("button");n.type="button",n.className="jsoneditor-schema-error",n.appendChild(i),n.onmouseover=n.onfocus=function(){for(var e=["right","above","below","left"],t=0;t<e.length;t++){var n=e[t];i.className="jsoneditor-popover jsoneditor-"+n;var o=this.editor.content.getBoundingClientRect(),r=i.getBoundingClientRect();if(d.insideRect(o,r,20))break}}.bind(this);var o=this.errorChild;for(o&&(n.onclick=function(){o.findParents().forEach(function(e){e.expand(!1)}),o.scrollTo(function(){o.focus()})});t.firstChild;)t.removeChild(t.firstChild);t.appendChild(n)}else t&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)},n.prototype.getIndex=function(){return this.parent?this.parent.childs.indexOf(this):-1},n.prototype.setParent=function(e){this.parent=e},n.prototype.setField=function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t},n.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},n.prototype.setValue=function(e,t){var i,o,r,s=this.childs;if(s)for(;s.length;)this.removeChild(s[0],!1);if(this.type=this._getType(e),t&&t!=this.type){if("string"!=t||"auto"!=this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"==this.type){this.childs=[];for(var a=0,l=e.length;a<l;a++)void 0===(i=e[a])||i instanceof Function||(o=new n(this.editor,{value:i}),r=a<this.MAX_VISIBLE_CHILDS,this.appendChild(o,r,!1))
;this.value=""}else if("object"==this.type){this.childs=[],a=0;for(var c in e)e.hasOwnProperty(c)&&(i=e[c],void 0===i||i instanceof Function||(o=new n(this.editor,{field:c,value:i}),r=a<this.MAX_VISIBLE_CHILDS,this.appendChild(o,r,!1)),a++);this.value="",!0===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.childs=void 0,this.value=e;this.updateDom({updateIndexes:!0}),this.previousValue=this.value},n.prototype.getValue=function(){if("array"==this.type){var e=[];return this.childs.forEach(function(t){e.push(t.getValue())}),e}if("object"==this.type){var t={};return this.childs.forEach(function(e){t[e.getField()]=e.getValue()}),t}return void 0===this.value&&this._getDomValue(),this.value},n.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},n.prototype.getNodePath=function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e},n.prototype.clone=function(){var e=new n(this.editor);if(e.type=this.type,e.field=this.field,e.fieldInnerText=this.fieldInnerText,e.fieldEditable=this.fieldEditable,e.value=this.value,e.valueInnerText=this.valueInnerText,e.expanded=this.expanded,e.visibleChilds=this.visibleChilds,this.childs){var t=[];this.childs.forEach(function(i){var n=i.clone();n.setParent(e),t.push(n)}),e.childs=t}else e.childs=void 0;return e},n.prototype.expand=function(e){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-expanded"),this.showChilds(),!1!==e&&this.childs.forEach(function(t){t.expand(e)}))},n.prototype.collapse=function(e){this.childs&&(this.hideChilds(),!1!==e&&this.childs.forEach(function(t){t.collapse(e)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-collapsed"),this.expanded=!1)},n.prototype.showChilds=function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var i=this.getAppendDom();if(!i.parentNode){var n=e.nextSibling;n?t.insertBefore(i,n):t.appendChild(i)}for(var o=Math.min(this.childs.length,this.visibleChilds),n=this._getNextTr(),r=0;r<o;r++){var s=this.childs[r];s.getDom().parentNode||t.insertBefore(s.getDom(),n),s.showChilds()}var a=this.getShowMoreDom(),n=this._getNextTr();a.parentNode||t.insertBefore(a,n),this.showMore.updateDom()}}},n.prototype._getNextTr=function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0},n.prototype.hide=function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.hideChilds(e)},n.prototype.hideChilds=function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var i=this.getShowMoreDom();i.parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||delete this.visibleChilds}},n.prototype.expandTo=function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent},n.prototype.appendChild=function(e,t,i){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),o=this._getNextTr(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds(),this.visibleChilds++}!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}},n.prototype.moveBefore=function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}if(e.parent&&e.parent.removeChild(e),t instanceof f)if(this.childs.length+1>this.visibleChilds){var o=this.childs[this.visibleChilds-1];this.insertBefore(e,o)}else this.appendChild(e);else this.insertBefore(e,t);i&&i.removeChild(n)}},n.prototype.moveTo=function(e,t){if(e.parent==this){this.childs.indexOf(e)<t&&t++}var i=this.childs[t]||this.append;this.moveBefore(e,i)},n.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(this.visibleChilds++,t==this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1==i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),o=t.getDom(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},n.prototype.insertAfter=function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}},n.prototype.search=function(e,t){Array.isArray(t)||(t=[]);var i,n=e?e.toLowerCase():void 0;if(delete this.searchField,delete this.searchValue,void 0!==this.field&&t.length<=this.MAX_SEARCH_RESULTS){i=String(this.field).toLowerCase().indexOf(n),-1!==i&&(this.searchField=!0,t.push({node:this,elem:"field"})),this._updateDomField()}if(this._hasChilds())this.childs&&this.childs.forEach(function(i){i.search(e,t)});else if(void 0!==this.value&&t.length<=this.MAX_SEARCH_RESULTS){var o=String(this.value).toLowerCase();i=o.indexOf(n),-1!==i&&(this.searchValue=!0,t.push({node:this,elem:"value"})),this._updateDomValue()}return t},n.prototype.scrollTo=function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},n.prototype.expandPathToNode=function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=n.prototype.MAX_VISIBLE_CHILDS;e.parent.expand(!1),e=e.parent}},n.focusElement=void 0,n.prototype.focus=function(e){if(n.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),d.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),d.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),d.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),d.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),d.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),d.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},n.select=function(e){setTimeout(function(){d.selectContentEditable(e)},0)},n.prototype.blur=function(){this._getDomValue(!1),this._getDomField(!1)},n.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1},n.prototype.removeChild=function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}},n.prototype._remove=function(e){this.removeChild(e)},n.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var i,n=this.dom.tr?this.dom.tr.parentNode:void 0;i=this.expanded?this.getAppendDom():this.getDom();var o=i&&i.parentNode?i.nextSibling:void 0;this.hide({resetVisibleChilds:!1}),this.clearDom(),this.type=e,"object"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0==e.field&&(e.field="")}),"string"!=t&&"auto"!=t||(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!=t&&"auto"!=t||(this.expanded=!0)):this.expanded=!1,n&&(o?n.insertBefore(this.getDom(),o):n.appendChild(this.getDom())),this.showChilds()}else this.type=e;"auto"!=e&&"string"!=e||(this.value="string"==e?String(this.value):this._stringCast(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},n.prototype._getDomValue=function(e){if(this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=d.getInnerText(this.dom.value)),void 0!=this.valueInnerText)try{var t;if("string"==this.type)t=this._unescapeHTML(this.valueInnerText);else{var i=this._unescapeHTML(this.valueInnerText);t=this._stringCast(i)}t!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(t){if(this.value=void 0,!0!==e)throw t}},n.prototype._onChangeValue=function(){var e=this.editor.getDomSelection();if(e.range){var t=d.textDiff(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getDomSelection();if(i.range){var n=d.textDiff(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{node:this,oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value},n.prototype._onChangeField=function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var i=d.textDiff(this.field,t);e.range.startOffset=i.start,e.range.endOffset=i.end}var n=this.editor.getDomSelection();if(n.range){var o=d.textDiff(t,this.field);n.range.startOffset=o.start,n.range.endOffset=o.end}this.editor._onAction("editField",{node:this,oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field},n.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"==this.type?d.type(i):this.type,o="string"==n&&d.isUrl(i);t.push("jsoneditor-"+n),o&&t.push("jsoneditor-url");if(""==String(this.value)&&"array"!=this.type&&"object"!=this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"==n||"object"==n){var r=this.childs?this.childs.length:0;e.title=this.type+" containing "+r+" items"}else o&&this.editable.value?e.title=u("openUrl"):e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value==this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||this.schema.hasOwnProperty("oneOf")||this.schema.hasOwnProperty("anyOf")||this.schema.hasOwnProperty("allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);d.stripFormatting(e)}},n.prototype._updateDomField=function(){var e=this.dom.field;if(e){""==String(this.field)&&"array"!=this.parent.type?d.addClassName(e,"jsoneditor-empty"):d.removeClassName(e,"jsoneditor-empty"),this.searchFieldActive?d.addClassName(e,"jsoneditor-highlight-active"):d.removeClassName(e,"jsoneditor-highlight-active"),this.searchField?d.addClassName(e,"jsoneditor-highlight"):d.removeClassName(e,"jsoneditor-highlight"),d.stripFormatting(e)}},n.prototype._getDomField=function(e){if(this.dom.field&&this.fieldEditable&&(this.fieldInnerText=d.getInnerText(this.dom.field)),void 0!=this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText);t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(t){if(this.field=void 0,!0!==e)throw t}},n.prototype.validate=function(){var e=[];if("object"===this.type){for(var t={},i=[],n=0;n<this.childs.length;n++){var o=this.childs[n];t.hasOwnProperty(o.field)&&i.push(o.field),t[o.field]=!0}i.length>0&&(e=this.childs.filter(function(e){return-1!==i.indexOf(e.field)}).map(function(e){return{node:e,error:{message:u("duplicateKey")+' "'+e.field+'"'}}}))}if(this.childs)for(var n=0;n<this.childs.length;n++){var r=this.childs[n].validate();r.length>0&&(e=e.concat(r))}return e},n.prototype.clearDom=function(){this.dom={}},n.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),e.tr.node=this,"tree"===this.editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",e.drag=i,i.className="jsoneditor-dragarea",i.title=u("drag"),t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),o=document.createElement("button");o.type="button",e.menu=o,o.className="jsoneditor-contextmenu",o.title=u("actionsMenu"),n.appendChild(e.menu),e.tr.appendChild(n)}var r=document.createElement("td");return e.tr.appendChild(r),e.tree=this._createDomTree(),r.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},n.prototype.isVisible=function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1},n.onDragStart=function(e,t){if(!Array.isArray(e))return n.onDragStart([e],t);if(0!==e.length){var i=e[0],o=e[e.length-1],r=n.getNodeFromTarget(t.target),s=o.nextSibling(),a=i.editor,l=d.getAbsoluteTop(r.dom.tr)-d.getAbsoluteTop(i.dom.tr);a.mousemove||(a.mousemove=d.addEventListener(window,"mousemove",function(t){n.onDrag(e,t)})),a.mouseup||(a.mouseup=d.addEventListener(window,"mouseup",function(t){n.onDragEnd(e,t)})),a.highlighter.lock(),a.drag={oldCursor:document.body.style.cursor,oldSelection:a.getDomSelection(),oldBeforeNode:s,mouseX:t.pageX,offsetY:l,level:i.getLevel()},document.body.style.cursor="move",t.preventDefault()}},n.onDrag=function(e,t){if(!Array.isArray(e))return n.onDrag([e],t);if(0!==e.length){var i,o,r,s,a,l,c,h,u,p,m,g,v,y,b=e[0].editor,x=t.pageY-b.drag.offsetY,w=t.pageX,_=!1,C=e[0];if(i=C.dom.tr,u=d.getAbsoluteTop(i),g=i.offsetHeight,x<u){o=i;do{o=o.previousSibling,c=n.getNodeFromTarget(o),p=o?d.getAbsoluteTop(o):0}while(o&&x<p);c&&!c.parent&&(c=void 0),c||(l=i.parentNode.firstChild,o=l?l.nextSibling:void 0,(c=n.getNodeFromTarget(o))==C&&(c=void 0)),c&&c.isVisible()&&(o=c.dom.tr,p=o?d.getAbsoluteTop(o):0,x>p+g&&(c=void 0)),c&&(e.forEach(function(e){c.parent.moveBefore(e,c)}),_=!0)}else{var E=e[e.length-1];if(a=E.expanded&&E.append?E.append.getDom():E.dom.tr,s=a?a.nextSibling:void 0){m=d.getAbsoluteTop(s),r=s;do{h=n.getNodeFromTarget(r),r&&(v=r.nextSibling?d.getAbsoluteTop(r.nextSibling):0,y=r?v-m:0,h&&h.parent.childs.length==e.length&&h.parent.childs[e.length-1]==E&&(u+=27),r=r.nextSibling)}while(r&&x>u+y);if(h&&h.parent){var S=w-b.drag.mouseX,j=Math.round(S/24/2),N=b.drag.level+j,k=h.getLevel();for(o=h.dom.tr&&h.dom.tr.previousSibling;k<N&&o;){c=n.getNodeFromTarget(o);if(e.some(function(e){return e===c||c.isDescendantOf(e)}));else{if(!(c instanceof f))break;var T=c.parent.childs;if(T.length==e.length&&T[e.length-1]==E)break;h=n.getNodeFromTarget(o),k=h.getLevel()}o=o.previousSibling}h instanceof f&&!h.isVisible()&&h.parent.showMore.isVisible()&&(h=h._nextNode()),h&&h.dom.tr&&a.nextSibling!=h.dom.tr&&(e.forEach(function(e){h.parent.moveBefore(e,h)}),_=!0)}}}_&&(b.drag.mouseX=w,b.drag.level=C.getLevel()),b.startAutoScroll(x),t.preventDefault()}},n.onDragEnd=function(e,t){if(!Array.isArray(e))return n.onDrag([e],t);if(0!==e.length){var i=e[0],o=i.editor,r=i.parent,s=r.childs.indexOf(i),a=r.childs[s+e.length]||r.append;e[0]&&e[0].dom.menu.focus();var l={nodes:e,oldSelection:o.drag.oldSelection,newSelection:o.getDomSelection(),oldBeforeNode:o.drag.oldBeforeNode,newBeforeNode:a};l.oldBeforeNode!=l.newBeforeNode&&o._onAction("moveNodes",l),document.body.style.cursor=o.drag.oldCursor,o.highlighter.unlock(),e.forEach(function(e){t.target!==e.dom.drag&&t.target!==e.dom.menu&&o.highlighter.unhighlight()}),delete o.drag,o.mousemove&&(d.removeEventListener(window,"mousemove",o.mousemove),delete o.mousemove),o.mouseup&&(d.removeEventListener(window,"mouseup",o.mouseup),delete o.mouseup),o.stopAutoScroll(),t.preventDefault()}},n.prototype.isDescendantOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},n.prototype._createDomField=function(){return document.createElement("div")},n.prototype.setHighlight=function(e){this.dom.tr&&(e?d.addClassName(this.dom.tr,"jsoneditor-highlight"):d.removeClassName(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(e),this.childs&&this.childs.forEach(function(t){t.setHighlight(e)}))},n.prototype.setSelected=function(e,t){this.selected=e,this.dom.tr&&(e?d.addClassName(this.dom.tr,"jsoneditor-selected"):d.removeClassName(this.dom.tr,"jsoneditor-selected"),t?d.addClassName(this.dom.tr,"jsoneditor-first"):d.removeClassName(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(e),this.showMore&&this.showMore.setSelected(e),this.childs&&this.childs.forEach(function(t){t.setSelected(e)}))},n.prototype.updateValue=function(e){this.value=e,this.updateDom()},n.prototype.updateField=function(e){this.field=e,this.updateDom()},n.prototype.updateDom=function(e){var t=this.dom.tree;t&&(t.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):i.className="jsoneditor-readonly";var n;n=void 0!=this.index?this.index:void 0!=this.field?this.field:this._hasChilds()?this.type:"",i.innerHTML=this._escapeHTML(n),this._updateSchema()}var o=this.dom.value;if(o){var r=this.childs?this.childs.length:0;"array"==this.type?(o.innerHTML="["+r+"]",d.addClassName(this.dom.tr,"jsoneditor-expandable")):"object"==this.type?(o.innerHTML="{"+r+"}",d.addClassName(this.dom.tr,"jsoneditor-expandable")):(o.innerHTML=this._escapeHTML(this.value),d.removeClassName(this.dom.tr,"jsoneditor-expandable"))}this._updateDomField(),this._updateDomValue(),e&&!0===e.updateIndexes&&this._updateDomIndexes(),e&&!0===e.recurse&&this.childs&&this.childs.forEach(function(t){t.updateDom(e)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()},n.prototype._updateSchema=function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?n._findSchema(this.editor.options.schema,this.getPath()):null,this.schema?this.enum=n._findEnum(this.schema):delete this.enum)},n._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(i.length>0)return i[0].enum}return null},n._findSchema=function(e,t){var i=e,o=i,r=e.oneOf||e.anyOf||e.allOf;r||(r=[e]);for(var s=0;s<r.length;s++){i=r[s];for(var a=0;a<t.length&&i;a++){var l=t[a];if("string"==typeof l&&i.patternProperties&&a==t.length-1)for(var c in i.patternProperties)o=n._findSchema(i.patternProperties[c],t.slice(a,t.length));else i.items&&i.items.properties?(i=i.items.properties[l])&&(o=n._findSchema(i,t.slice(a,t.length))):"string"==typeof l&&i.properties?(i=i.properties[l]||null)&&(o=n._findSchema(i,t.slice(a,t.length))):"number"==typeof l&&i.items&&(i=i.items)&&(o=n._findSchema(i,t.slice(a,t.length)))}}return o},n.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){void 0!=e.index&&(delete e.index,void 0==e.field&&(e.field=""))}))},n.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div"),e.innerHTML="[...]"):"object"==this.type?(e=document.createElement("div"),e.innerHTML="{...}"):!this.editable.value&&d.isUrl(this.value)?(e=document.createElement("a"),e.href=this.value,e.innerHTML=this._escapeHTML(this.value)):(e=document.createElement("div"),e.contentEditable=this.editable.value,e.spellcheck=!1,e.innerHTML=this._escapeHTML(this.value)),e},n.prototype._createDomExpandButton=function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-expanded":"jsoneditor-collapsed",e.title=u("expandTitle")):(e.className="jsoneditor-invisible",e.title=""),e},n.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.expand=this._createDomExpandButton(),o.appendChild(e.expand),e.tdExpand=o;var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.field=this._createDomField(),r.appendChild(e.field),e.tdField=r;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},n.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,o=this,r=this._hasChilds();if(i!=n.drag&&i!=n.menu||("mouseover"==t?this.editor.highlighter.highlight(this):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var s=o.editor.highlighter;s.highlight(o),s.lock(),d.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){d.removeClassName(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"==t&&(i==n.expand||("view"===o.editor.options.mode||"form"===o.editor.options.mode)&&"DIV"===i.nodeName)&&r){var a=e.ctrlKey;this._onExpand(a)}"change"==t&&i==n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue()),"change"==t&&i==n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var l=n.value;if(i==l)switch(t){case"blur":case"change":this._getDomValue(!0),this._updateDomValue(),this.value&&(l.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(!0),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&d.isUrl(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(!0),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){o._getDomValue(!0),o._updateDomValue()},1)}var c=n.field;if(i==c)switch(t){case"blur":case"change":this._getDomField(!0),this._updateDomField(),this.field&&(c.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(!0),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(!0),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){o._getDomField(!0),o._updateDomField()},1)}var h=n.tree;if(h&&i==h.parentNode&&"click"==t&&!e.hasMoved){(void 0!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<d.getAbsoluteLeft(n.tdSeparator))||r?c&&(d.setEndOfContentEditable(c),c.focus()):l&&!this.enum&&(d.setEndOfContentEditable(l),l.focus())}(i!=n.tdExpand||r)&&i!=n.tdField&&i!=n.tdSeparator||"click"!=t||e.hasMoved||c&&(d.setEndOfContentEditable(c),c.focus()),"keydown"==t&&this.onKeyDown(e)},n.prototype.onKeyDown=function(e){var t,i,o,r,s,a,l,c,h=e.which||e.keyCode,u=e.target||e.srcElement,p=e.ctrlKey,m=e.shiftKey,g=e.altKey,v=!1,y="tree"===this.editor.options.mode,b=this.editor.multiselection.nodes.length>0?this.editor.multiselection.nodes:[this],x=b[0],w=b[b.length-1];if(13==h){if(u==this.dom.value)this.editable.value&&!e.ctrlKey||d.isUrl(this.value)&&(window.open(this.value,"_blank"),v=!0);else if(u==this.dom.expand){var _=this._hasChilds();if(_){var C=e.ctrlKey;this._onExpand(C),u.focus(),v=!0}}}else if(68==h)p&&y&&(n.onDuplicate(b),v=!0);else if(69==h)p&&(this._onExpand(m),u.focus(),v=!0);else if(77==h&&y)p&&(this.showContextMenu(u),v=!0);else if(46==h&&y)p&&(n.onRemove(b),v=!0);else if(45==h&&y)p&&!m?(this._onInsertBefore(),v=!0):p&&m&&(this._onInsertAfter(),v=!0);else if(35==h){if(g){var E=this._lastNode();E&&E.focus(n.focusElement||this._getElementName(u)),v=!0}}else if(36==h){if(g){var S=this._firstNode();S&&S.focus(n.focusElement||this._getElementName(u)),v=!0}}else if(37==h){if(g&&!m){var j=this._previousElement(u);j&&this.focus(this._getElementName(j)),v=!0}else if(g&&m&&y){if(w.expanded){var N=w.getAppendDom();o=N?N.nextSibling:void 0}else{var k=w.getDom();o=k.nextSibling}o&&(i=n.getNodeFromTarget(o),r=o.nextSibling,D=n.getNodeFromTarget(r),i&&i instanceof f&&1!=w.parent.childs.length&&D&&D.parent&&(s=this.editor.getDomSelection(),a=w.nextSibling(),b.forEach(function(e){D.parent.moveBefore(e,D)}),this.focus(n.focusElement||this._getElementName(u)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:D,oldSelection:s,newSelection:this.editor.getDomSelection()})))}}else if(38==h)g&&!m?(t=this._previousNode(),t&&(this.editor.deselect(!0),t.focus(n.focusElement||this._getElementName(u))),v=!0):!g&&p&&m&&y?(t=this._previousNode(),t&&(c=this.editor.multiselection,c.start=c.start||this,c.end=t,l=this.editor._findTopLevelNodes(c.start,c.end),this.editor.select(l),t.focus("field")),v=!0):g&&m&&y&&(t=x._previousNode(),t&&t.parent&&(s=this.editor.getDomSelection(),a=w.nextSibling(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(n.focusElement||this._getElementName(u)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:t,oldSelection:s,newSelection:this.editor.getDomSelection()})),v=!0);else if(39==h){if(g&&!m){var T=this._nextElement(u);T&&this.focus(this._getElementName(T)),v=!0}else if(g&&m&&y){k=x.getDom();var O=k.previousSibling;O&&(t=n.getNodeFromTarget(O))&&t.parent&&!t.isVisible()&&(s=this.editor.getDomSelection(),a=w.nextSibling(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(n.focusElement||this._getElementName(u)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:t,oldSelection:s,newSelection:this.editor.getDomSelection()}))}}else if(40==h)if(g&&!m)i=this._nextNode(),i&&(this.editor.deselect(!0),i.focus(n.focusElement||this._getElementName(u))),v=!0;else if(!g&&p&&m&&y)i=this._nextNode(),i&&(c=this.editor.multiselection,c.start=c.start||this,c.end=i,l=this.editor._findTopLevelNodes(c.start,c.end),this.editor.select(l),i.focus("field")),v=!0;else if(g&&m&&y){i=w.expanded?w.append?w.append._nextNode():void 0:w._nextNode(),i&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof f&&(i=w);var D=i&&(i._nextNode()||i.parent.append);D&&D.parent&&(s=this.editor.getDomSelection(),a=w.nextSibling(),b.forEach(function(e){D.parent.moveBefore(e,D)}),this.focus(n.focusElement||this._getElementName(u)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:a,newBeforeNode:D,oldSelection:s,newSelection:this.editor.getDomSelection()})),v=!0}v&&(e.preventDefault(),e.stopPropagation())},n.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)},n.onRemove=function(e){if(!Array.isArray(e))return n.onRemove([e]);if(e&&e.length>0){var t=e[0],i=t.parent,o=t.editor,r=t.getIndex();o.highlighter.unhighlight();var s=o.getDomSelection();n.blurNodes(e);var a=o.getDomSelection();e.forEach(function(e){e.parent._remove(e)}),o._onAction("removeNodes",{nodes:e.slice(0),parent:i,index:r,oldSelection:s,newSelection:a})}},n.onDuplicate=function(e){if(!Array.isArray(e))return n.onDuplicate([e]);if(e&&e.length>0){var t=e[e.length-1],i=t.parent,o=t.editor;o.deselect(o.multiselection.nodes);var r=o.getDomSelection(),s=t,a=e.map(function(e){var t=e.clone();return i.insertAfter(t,s),s=t,t});1===e.length?a[0].focus():o.select(a);var l=o.getDomSelection();o._onAction("duplicateNodes",{afterNode:t,nodes:a,parent:i,oldSelection:r,newSelection:l})}},n.prototype._onInsertBefore=function(e,t,i){var o=this.editor.getDomSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[r],beforeNode:this,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onInsertAfter=function(e,t,i){var o=this.editor.getDomSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[r],afterNode:this,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onAppend=function(e,t,i){var o=this.editor.getDomSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[r],parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var i=this.editor.getDomSelection();this.changeType(e);var n=this.editor.getDomSelection();this.editor._onAction("changeType",{node:this,oldType:t,newType:e,oldSelection:i,newSelection:n})}},n.prototype.sort=function(e,t){if(this._hasChilds()){this.hideChilds();var i=this.childs;this.childs=this.childs.concat();var n="desc"===t?-1:1;"object"===this.type?this.childs.sort(function(e,t){return n*r(e.field,t.field)}):this.childs.sort(function(t,i){var o=t.getNestedChild(e),s=i.getNestedChild(e);if(!o)return n;if(!s)return-n;var a=o.value,l=s.value;return"string"!=typeof a&&"string"!=typeof l?a>l?n:a<l?-n:0:n*r(a,l)}),this._updateDomIndexes(),this.editor._onAction("sort",{node:this,oldChilds:i,newChilds:this.childs}),this.showChilds()}},n.prototype.transform=function(e){if(this._hasChilds()){this.hideChilds();var t=this.type,i=this.childs;this.childs=this.childs.concat();try{var n=this.getValue(),r=o.search(n,e);this.setValue(r),this.editor._onAction("transform",{node:this,oldType:t,newType:this.type,oldValue:n,newValue:r,oldChilds:i,newChilds:this.childs}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}},n.prototype.getNestedChild=function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i},n.prototype.findChildByProperty=function(e){if("object"===this.type)return this.childs.find(function(t){return t.field===e})},n.prototype.getChildPaths=function(e){var t={};return this._getChildPaths(t,"",e),"array"===this.type&&this.childs.forEach(function(i){i._getChildPaths(t,"",e)}),Object.keys(t).sort()},n.prototype._getChildPaths=function(e,t,i){("auto"===this.type||"string"===this.type||i)&&(e[t||"."]=!0),"object"===this.type&&this.childs.forEach(function(n){n._getChildPaths(e,t+"."+n.field,i)})},n.prototype.getAppendDom=function(){return this.append||(this.append=new f(this.editor),this.append.setParent(this)),this.append.getDom()},n.prototype.getShowMoreDom=function(){return this.showMore||(this.showMore=new m(this.editor,this)),this.showMore.getDom()},n.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},n.blurNodes=function(e){if(!Array.isArray(e))return void n.blurNodes([e]);var t=e[0],i=t.parent,o=t.getIndex();i.childs[o+e.length]?i.childs[o+e.length].focus():i.childs[o-1]?i.childs[o-1].focus():i.focus()},n.prototype.nextSibling=function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append},n.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do{i=i.previousSibling,e=n.getNodeFromTarget(i)}while(i&&e&&e instanceof f&&!e.isVisible())}return e},n.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do{i=i.nextSibling,e=n.getNodeFromTarget(i)}while(i&&e&&e instanceof f&&!e.isVisible())}return e},n.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=n.getNodeFromTarget(i)}return e},n.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=n.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=n.getNodeFromTarget(i)}return e},n.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},n.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},n.prototype._getElementName=function(e){var t=this.dom;for(var i in t)if(t.hasOwnProperty(i)&&t[i]==e)return i;return null},n.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},n.TYPE_TITLES={auto:u("autoType"),object:u("objectType"),array:u("arrayType"),string:u("stringType")},n.prototype.addTemplates=function(e,t){var i=this,n=i.editor.options.templates;if(null!=n){n.length&&e.push({type:"separator"});var o=function(e,t){i._onAppend(e,t)},r=function(e,t){i._onInsertBefore(e,t)};n.forEach(function(i){e.push({text:i.text,className:i.className||"jsoneditor-type-object",title:i.title,click:t?o.bind(this,i.field,i.value):r.bind(this,i.field,i.value)})})}},n.prototype.showContextMenu=function(e,t){var i=this,o=n.TYPE_TITLES,r=[];if(this.editable.value&&r.push({text:u("type"),title:u("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:u("auto"),className:"jsoneditor-type-auto"+("auto"==this.type?" jsoneditor-selected":""),title:o.auto,click:function(){i._onChangeType("auto")}},{text:u("array"),className:"jsoneditor-type-array"+("array"==this.type?" jsoneditor-selected":""),title:o.array,click:function(){i._onChangeType("array")}},{text:u("object"),className:"jsoneditor-type-object"+("object"==this.type?" jsoneditor-selected":""),title:o.object,click:function(){i._onChangeType("object")}},{text:u("string"),className:"jsoneditor-type-string"+("string"==this.type?" jsoneditor-selected":""),title:o.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(r.push({text:u("sort"),title:u("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){var e=i.editor.options.modalAnchor||p;c(i,e)}}),r.push({text:u("transform"),title:u("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){var e=i.editor.options.modalAnchor||p;h(i,e)}})),this.parent&&this.parent._hasChilds()){r.length&&r.push({type:"separator"});var a=i.parent.childs;if(i==a[a.length-1]){var l=[{text:u("auto"),className:"jsoneditor-type-auto",title:o.auto,click:function(){i._onAppend("","","auto")}},{text:u("array"),className:"jsoneditor-type-array",title:o.array,click:function(){i._onAppend("",[])}},{text:u("object"),className:"jsoneditor-type-object",title:o.object,click:function(){i._onAppend("",{})}},{text:u("string"),className:"jsoneditor-type-string",title:o.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(l,!0),r.push({text:u("appendText"),title:u("appendTitle"),submenuTitle:u("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:l})}var d=[{text:u("auto"),className:"jsoneditor-type-auto",title:o.auto,click:function(){i._onInsertBefore("","","auto")}},{text:u("array"),className:"jsoneditor-type-array",title:o.array,click:function(){i._onInsertBefore("",[])}},{text:u("object"),className:"jsoneditor-type-object",title:o.object,click:function(){i._onInsertBefore("",{})}},{text:u("string"),className:"jsoneditor-type-string",title:o.string,click:function(){i._onInsertBefore("","","string")}}];i.addTemplates(d,!1),r.push({text:u("insert"),title:u("insertTitle"),submenuTitle:u("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:d}),this.editable.field&&(r.push({text:u("duplicateText"),title:u("duplicateField"),className:"jsoneditor-duplicate",click:function(){n.onDuplicate(i)}}),r.push({text:u("removeText"),title:u("removeField"),className:"jsoneditor-remove",click:function(){n.onRemove(i)}}))}new s(r,{close:t}).show(e,this.editor.content)},n.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof this._stringCast(e)?"string":"auto"},n.prototype._stringCast=function(e){var t=e.toLowerCase(),i=Number(e),n=parseFloat(e);return""==e?"":"null"==t?null:"true"==t||"false"!=t&&(isNaN(i)||isNaN(n)?e:i)},n.prototype._escapeHTML=function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=d.escapeUnicodeChars(n)),n},n.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"';return d.parse(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")},n.prototype._escapeJSON=function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"==n?t+="\\n":"\\"==n?(t+=n,i++,n=e.charAt(i),""!==n&&-1!='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'==n?'\\"':n,i++}return t};var f=a(n),m=l(n);e.exports=n},function(e,t,i){!function(e){"use strict";function t(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function i(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function n(e,o){if(e===o)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(o))return!1;if(!0===t(e)){if(e.length!==o.length)return!1;for(var r=0;r<e.length;r++)if(!1===n(e[r],o[r]))return!1;return!0}if(!0===i(e)){var s={};for(var a in e)if(hasOwnProperty.call(e,a)){if(!1===n(e[a],o[a]))return!1;s[a]=!0}for(var l in o)if(hasOwnProperty.call(o,l)&&!0!==s[l])return!1;return!0}return!1}function o(e){if(""===e||!1===e||null===e)return!0;if(t(e)&&0===e.length)return!0;if(i(e)){for(var n in e)if(e.hasOwnProperty(n))return!1;return!0}return!1}function r(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}function s(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"||"_"===e}function a(e){return e>="0"&&e<="9"||"-"===e}function l(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"||e>="0"&&e<="9"||"_"===e}function c(){}function h(){}function d(e){this.runtime=e}function u(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[v]}]},avg:{_func:this._functionAvg,_signature:[{types:[C]}]},ceil:{_func:this._functionCeil,_signature:[{types:[v]}]},contains:{_func:this._functionContains,_signature:[{types:[b,x]},{types:[y]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[b]},{types:[b]}]},floor:{_func:this._functionFloor,_signature:[{types:[v]}]},length:{_func:this._functionLength,_signature:[{types:[b,x,w]}]},map:{_func:this._functionMap,_signature:[{types:[_]},{types:[x]}]},max:{_func:this._functionMax,_signature:[{types:[C,E]}]},merge:{_func:this._functionMerge,_signature:[{types:[w],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[x]},{types:[_]}]},sum:{_func:this._functionSum,_signature:[{types:[C]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[b]},{types:[b]}]},min:{_func:this._functionMin,_signature:[{types:[C,E]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[x]},{types:[_]}]},type:{_func:this._functionType,_signature:[{types:[y]}]},keys:{_func:this._functionKeys,_signature:[{types:[w]}]},values:{_func:this._functionValues,_signature:[{types:[w]}]},sort:{_func:this._functionSort,_signature:[{types:[E,C]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[x]},{types:[_]}]},join:{_func:this._functionJoin,_signature:[{types:[b]},{types:[E]}]},reverse:{_func:this._functionReverse,_signature:[{types:[b,x]}]},to_array:{_func:this._functionToArray,_signature:[{types:[y]}]},to_string:{_func:this._functionToString,_signature:[{types:[y]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[y]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[y],variadic:!0}]}}}function p(e){return(new h).parse(e)}function f(e){return(new c).tokenize(e)}function m(e,t){var i=new h,n=new u,o=new d(n);n._interpreter=o;var r=i.parse(t);return o.search(r,e)}var g;g="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]};var v=0,y=1,b=2,x=3,w=4,_=6,C=8,E=9,S={".":"Dot","*":"Star",",":"Comma",":":"Colon","{":"Lbrace","}":"Rbrace","]":"Rbracket","(":"Lparen",")":"Rparen","@":"Current"},j={"<":!0,">":!0,"=":!0,"!":!0},N={" ":!0,"\t":!0,"\n":!0};c.prototype={tokenize:function(e){var t=[];this._current=0;for(var i,n,o;this._current<e.length;)if(s(e[this._current]))i=this._current,n=this._consumeUnquotedIdentifier(e),t.push({type:"UnquotedIdentifier",value:n,start:i});else if(void 0!==S[e[this._current]])t.push({type:S[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(a(e[this._current]))o=this._consumeNumber(e),t.push(o);else if("["===e[this._current])o=this._consumeLBracket(e),t.push(o);else if('"'===e[this._current])i=this._current,n=this._consumeQuotedIdentifier(e),t.push({type:"QuotedIdentifier",value:n,start:i});else if("'"===e[this._current])i=this._current,n=this._consumeRawStringLiteral(e),t.push({type:"Literal",value:n,start:i});else if("`"===e[this._current]){i=this._current;var r=this._consumeLiteral(e);t.push({type:"Literal",value:r,start:i})}else if(void 0!==j[e[this._current]])t.push(this._consumeOperator(e));else if(void 0!==N[e[this._current]])this._current++;else if("&"===e[this._current])i=this._current,this._current++,"&"===e[this._current]?(this._current++,t.push({type:"And",value:"&&",start:i})):t.push({type:"Expref",value:"&",start:i});else{if("|"!==e[this._current]){var l=new Error("Unknown character:"+e[this._current]);throw l.name="LexerError",l}i=this._current,this._current++,"|"===e[this._current]?(this._current++,t.push({type:"Or",value:"||",start:i})):t.push({type:"Pipe",value:"|",start:i})}return t},_consumeUnquotedIdentifier:function(e){var t=this._current;for(this._current++;this._current<e.length&&l(e[this._current]);)this._current++;return e.slice(t,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;a(e[this._current])&&this._current<i;)this._current++;return{type:"Number",value:parseInt(e.slice(t,this._current)),start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:"Filter",value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:"Flatten",value:"[]",start:t}):{type:"Lbracket",value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:"LTE",value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:"GTE",value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t,i=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var o=this._current;"\\"!==e[o]||"\\"!==e[o+1]&&"`"!==e[o+1]?o++:o+=2,this._current=o}var r=g(e.slice(i,this._current));return r=r.replace("\\`","`"),t=this._looksLikeJSON(r)?JSON.parse(r):JSON.parse('"'+r+'"'),this._current++,t},_looksLikeJSON:function(e){var t='[{"',i=["true","false","null"],n="-0123456789";if(""===e)return!1;if(t.indexOf(e[0])>=0)return!0;if(i.indexOf(e)>=0)return!0;if(!(n.indexOf(e[0])>=0))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var k={};k.EOF=0,k.UnquotedIdentifier=0,k.QuotedIdentifier=0,k.Rbracket=0,k.Rparen=0,k.Comma=0,k.Rbrace=0,k.Number=0,k.Current=0,k.Expref=0,k.Pipe=1,k.Or=2,k.And=3,k.EQ=5,k.GT=5,k.LT=5,k.GTE=5,k.LTE=5,k.NE=5,k.Flatten=9,k.Star=20,k.Filter=21,k.Dot=40,k.Not=45,k.Lbrace=50,k.Lbracket=55,k.Lparen=60,h.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"!==this._lookahead(0)){var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n}return t},_loadTokens:function(e){var t=new c,i=t.tokenize(e);i.push({type:"EOF",value:"",start:e.length}),this.tokens=i},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<k[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i,n;switch(e.type){case"Literal":return{type:"Literal",value:e.value};case"UnquotedIdentifier":return{type:"Field",name:e.value};case"QuotedIdentifier":var o={type:"Field",name:e.value};if("Lparen"===this._lookahead(0))throw new Error("Quoted identifier not allowed for function names.");return o;case"Not":return i=this.expression(k.Not),{type:"NotExpression",children:[i]};case"Star":return t={type:"Identity"},i=null,i="Rbracket"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(k.Star),{type:"ValueProjection",children:[t,i]};case"Filter":return this.led(e.type,{type:"Identity"});case"Lbrace":return this._parseMultiselectHash();case"Flatten":return t={type:"Flatten",children:[{type:"Identity"}]},i=this._parseProjectionRHS(k.Flatten),{type:"Projection",children:[t,i]};case"Lbracket":return"Number"===this._lookahead(0)||"Colon"===this._lookahead(0)?(i=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},i)):"Star"===this._lookahead(0)&&"Rbracket"===this._lookahead(1)?(this._advance(),this._advance(),i=this._parseProjectionRHS(k.Star),{type:"Projection",children:[{type:"Identity"},i]}):this._parseMultiselectList();case"Current":return{type:"Current"};case"Expref":return n=this.expression(k.Expref),{type:"ExpressionReference",children:[n]};case"Lparen":for(var r=[];"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(n={type:"Current"},this._advance()):n=this.expression(0),r.push(n);return this._match("Rparen"),r[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case"Dot":var n=k.Dot;return"Star"!==this._lookahead(0)?(i=this._parseDotRHS(n),{type:"Subexpression",children:[t,i]}):(this._advance(),i=this._parseProjectionRHS(n),{type:"ValueProjection",children:[t,i]});case"Pipe":return i=this.expression(k.Pipe),{type:"Pipe",children:[t,i]};case"Or":return i=this.expression(k.Or),{type:"OrExpression",children:[t,i]};case"And":return i=this.expression(k.And),{type:"AndExpression",children:[t,i]};case"Lparen":for(var o,r=t.name,s=[];"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(o={type:"Current"},this._advance()):o=this.expression(0),"Comma"===this._lookahead(0)&&this._match("Comma"),s.push(o);return this._match("Rparen"),{type:"Function",name:r,children:s};case"Filter":var a=this.expression(0);return this._match("Rbracket"),i="Flatten"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(k.Filter),{type:"FilterProjection",children:[t,i,a]};case"Flatten":return{type:"Projection",children:[{type:"Flatten",children:[t]},this._parseProjectionRHS(k.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(t,e);case"Lbracket":var l=this._lookaheadToken(0);return"Number"===l.type||"Colon"===l.type?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match("Star"),this._match("Rbracket"),i=this._parseProjectionRHS(k.Star),{type:"Projection",children:[t,i]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if("Colon"===this._lookahead(0)||"Colon"===this._lookahead(1))return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match("Rbracket"),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(k.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);"Rbracket"!==i&&t<3;){if("Colon"===i)t++,this._advance();else{if("Number"!==i){var n=this._lookahead(0),o=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw o.name="Parsererror",o}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match("Rbracket"),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(k[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return["UnquotedIdentifier","QuotedIdentifier","Star"].indexOf(t)>=0?this.expression(e):"Lbracket"===t?(this._match("Lbracket"),this._parseMultiselectList()):"Lbrace"===t?(this._match("Lbrace"),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(k[this._lookahead(0)]<10)t={type:"Identity"};else if("Lbracket"===this._lookahead(0))t=this.expression(e);else if("Filter"===this._lookahead(0))t=this.expression(e);else{if("Dot"!==this._lookahead(0)){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match("Dot"),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];"Rbracket"!==this._lookahead(0);){var t=this.expression(0);if(e.push(t),"Comma"===this._lookahead(0)&&(this._match("Comma"),"Rbracket"===this._lookahead(0)))throw new Error("Unexpected token Rbracket")}return this._match("Rbracket"),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n,o=[],r=["UnquotedIdentifier","QuotedIdentifier"];;){if(e=this._lookaheadToken(0),r.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match("Colon"),i=this.expression(0),n={type:"KeyValuePair",name:t,value:i},o.push(n),"Comma"===this._lookahead(0))this._match("Comma");else if("Rbrace"===this._lookahead(0)){this._match("Rbrace");break}}return{type:"MultiSelectHash",children:o}}},d.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,s){var a,l,c,h,d,u,p,f,m;switch(e.type){case"Field":return null===s?null:i(s)?(u=s[e.name],void 0===u?null:u):null;case"Subexpression":for(c=this.visit(e.children[0],s),m=1;m<e.children.length;m++)if(null===(c=this.visit(e.children[1],c)))return null;return c;case"IndexExpression":return p=this.visit(e.children[0],s),this.visit(e.children[1],p);case"Index":if(!t(s))return null;var g=e.value;return g<0&&(g=s.length+g),c=s[g],void 0===c&&(c=null),c;case"Slice":if(!t(s))return null;var v=e.children.slice(0),y=this.computeSliceParams(s.length,v),b=y[0],x=y[1],w=y[2];if(c=[],w>0)for(m=b;m<x;m+=w)c.push(s[m]);else for(m=b;m>x;m+=w)c.push(s[m]);return c;case"Projection":var _=this.visit(e.children[0],s);if(!t(_))return null;for(f=[],m=0;m<_.length;m++)null!==(l=this.visit(e.children[1],_[m]))&&f.push(l);return f;case"ValueProjection":if(_=this.visit(e.children[0],s),!i(_))return null;f=[];var C=r(_);for(m=0;m<C.length;m++)null!==(l=this.visit(e.children[1],C[m]))&&f.push(l);return f;case"FilterProjection":if(_=this.visit(e.children[0],s),!t(_))return null;var E=[],S=[];for(m=0;m<_.length;m++)a=this.visit(e.children[2],_[m]),o(a)||E.push(_[m]);for(var j=0;j<E.length;j++)null!==(l=this.visit(e.children[1],E[j]))&&S.push(l);return S;case"Comparator":switch(h=this.visit(e.children[0],s),d=this.visit(e.children[1],s),e.name){case"EQ":c=n(h,d);break;case"NE":c=!n(h,d);break;case"GT":c=h>d;break;case"GTE":c=h>=d;break;case"LT":c=h<d;break;case"LTE":c=h<=d;break;default:throw new Error("Unknown comparator: "+e.name)}return c;case"Flatten":var N=this.visit(e.children[0],s);if(!t(N))return null;var k=[];for(m=0;m<N.length;m++)l=N[m],t(l)?k.push.apply(k,l):k.push(l);return k;case"Identity":return s;case"MultiSelectList":if(null===s)return null;for(f=[],m=0;m<e.children.length;m++)f.push(this.visit(e.children[m],s));return f;case"MultiSelectHash":if(null===s)return null;f={};var T;for(m=0;m<e.children.length;m++)T=e.children[m],f[T.name]=this.visit(T.value,s);return f;case"OrExpression":return a=this.visit(e.children[0],s),o(a)&&(a=this.visit(e.children[1],s)),a;case"AndExpression":return h=this.visit(e.children[0],s),!0===o(h)?h:this.visit(e.children[1],s);case"NotExpression":return h=this.visit(e.children[0],s),o(h);case"Literal":return e.value;case"Pipe":return p=this.visit(e.children[0],s),this.visit(e.children[1],p);case"Current":return s;case"Function":var O=[];for(m=0;m<e.children.length;m++)O.push(this.visit(e.children[m],s));return this.runtime.callFunction(e.name,O);case"ExpressionReference":var D=e.children[0];return D.jmespathType="Expref",D;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],o=t[2],r=[null,null,null];if(null===o)o=1;else if(0===o){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=o<0;return i=null===i?a?e-1:0:this.capSliceRange(e,i,o),n=null===n?a?-1:e:this.capSliceRange(e,n,o),r[0]=i,r[1]=n,r[2]=o,r},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):t>=e&&(t=i<0?e-1:e),t}},u.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var o,r,s,a=0;a<i.length;a++){s=!1,o=i[a].types,r=this._getTypeName(t[a]);for(var l=0;l<o.length;l++)if(this._typeMatches(r,o[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+o+" but received type "+r+" instead.")}},_typeMatches:function(e,t,i){if(t===y)return!0;if(t!==E&&t!==C&&t!==x)return e===t;if(t===x)return e===x;if(e===x){var n;t===C?n=v:t===E&&(n=b);for(var o=0;o<i.length;o++)if(!this._typeMatches(this._getTypeName(i[o]),n,i[o]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return b;case"[object Number]":return v;case"[object Array]":return x;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return"Expref"===e.jmespathType?_:w}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===b){for(var t=e[0],i="",n=t.length-1;n>=0;n--)i+=t[n];return i}var o=e[0].slice(0);return o.reverse(),o},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return e[0].indexOf(e[1])>=0},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return i(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],o=e[1],r=0;r<o.length;r++)t.push(i.visit(n,o[r]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var o in n)t[o]=n[o]}return t},_functionMax:function(e){if(e[0].length>0){if(this._getTypeName(e[0][0])===v)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(e[0].length>0){if(this._getTypeName(e[0][0])===v)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case v:return"number";case b:return"string";case x:return"array";case w:return"object";case 5:return"boolean";case _:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],o=0;o<i.length;o++)n.push(t[i[o]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===x?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===b?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===v?e[0]:i!==b||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var i=this._interpreter,n=e[1],o=this._getTypeName(i.visit(n,t[0]));if([v,b].indexOf(o)<0)throw new Error("TypeError");for(var r=this,s=[],a=0;a<t.length;a++)s.push([a,t[a]]);s.sort(function(e,t){var s=i.visit(n,e[1]),a=i.visit(n,t[1]);if(r._getTypeName(s)!==o)throw new Error("TypeError: expected "+o+", received "+r._getTypeName(s));if(r._getTypeName(a)!==o)throw new Error("TypeError: expected "+o+", received "+r._getTypeName(a));return s>a?1:s<a?-1:e[0]-t[0]});for(var l=0;l<s.length;l++)t[l]=s[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],o=e[0],r=this.createKeyFunction(n,[v,b]),s=-1/0,a=0;a<o.length;a++)(i=r(o[a]))>s&&(s=i,t=o[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],o=e[0],r=this.createKeyFunction(n,[v,b]),s=1/0,a=0;a<o.length;a++)(i=r(o[a]))<s&&(s=i,t=o[a]);return t},createKeyFunction:function(e,t){var i=this,n=this._interpreter;return function(o){var r=n.visit(e,o);if(t.indexOf(i._getTypeName(r))<0){var s="TypeError: expected one of "+t+", received "+i._getTypeName(r);throw new Error(s)}return r}}},e.tokenize=f,e.compile=p,e.search=m,e.strictDeepEqual=n}(t)},function(e,t){e.exports=function e(t,i){"use strict";var n,o,r=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,s=/(^[ ]*|[ ]*$)/g,a=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,l=/^0x[0-9a-f]+$/i,c=function(t){return e.insensitive&&(""+t).toLowerCase()||""+t},h=c(t).replace(s,"")||"",d=c(i).replace(s,"")||"",u=h.replace(r,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=d.replace(r,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),f=parseInt(h.match(l),16)||1!==u.length&&h.match(a)&&Date.parse(h),m=parseInt(d.match(l),16)||f&&d.match(a)&&Date.parse(d)||null;if(m){if(f<m)return-1;if(f>m)return 1}for(var g=0,v=Math.max(u.length,p.length);g<v;g++){if(n=!(u[g]||"").match(/^0/)&&parseFloat(u[g])||u[g]||0,o=!(p[g]||"").match(/^0/)&&parseFloat(p[g])||p[g]||0,isNaN(n)!==isNaN(o))return isNaN(n)?1:-1;if(typeof n!=typeof o&&(n+="",o+=""),n<o)return-1;if(n>o)return 1}return 0}},function(e,t,i){"use strict";function n(e){function t(e){this.editor=e,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-contextmenu",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var o=document.createElement("td"),r=document.createElement("div");return r.innerHTML="("+s("empty")+")",r.className="jsoneditor-readonly",o.appendChild(r),e.td=o,e.text=r,this.updateDom(),t},t.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.innerHTML="("+s("empty")+" "+this.parent.type+")");var o=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&o.appendChild(t.tdDrag),t.tdMenu&&o.appendChild(t.tdMenu),o.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&o.removeChild(t.tdDrag),t.tdMenu&&o.removeChild(t.tdMenu),o.removeChild(i))},t.prototype.isVisible=function(){return 0==this.parent.childs.length},t.prototype.showContextMenu=function(t,i){var n=this,o=e.TYPE_TITLES,a=[{text:s("auto"),className:"jsoneditor-type-auto",title:o.auto,click:function(){n._onAppend("","","auto")}},{text:s("array"),className:"jsoneditor-type-array",title:o.array,click:function(){n._onAppend("",[])}},{text:s("object"),className:"jsoneditor-type-object",title:o.object,click:function(){n._onAppend("",{})}},{text:s("string"),className:"jsoneditor-type-string",title:o.string,click:function(){n._onAppend("","","string")}}];n.addTemplates(a,!0);var l=[{text:s("appendText"),title:s("appendTitleAuto"),submenuTitle:s("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){n._onAppend("","","auto")},submenu:a}];new r(l,{close:i}).show(t,this.editor.content)},t.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom
;if(i==n.menu&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var r=this.editor.highlighter;r.highlight(this.parent),r.lock(),o.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){o.removeClassName(n.menu,"jsoneditor-selected"),r.unlock(),r.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},t}var o=i(4),r=i(7),s=i(8).translate;e.exports=n},function(e,t,i){"use strict";function n(e){function t(e,t){this.editor=e,this.parent=t,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var e=this,t=this.parent,i=document.createElement("a");i.appendChild(document.createTextNode(o("showMore"))),i.href="#",i.onclick=function(i){return t.visibleChilds=Math.floor(t.visibleChilds/t.MAX_VISIBLE_CHILDS+1)*t.MAX_VISIBLE_CHILDS,e.updateDom(),t.showChilds(),i.preventDefault(),!1};var n=document.createElement("a");n.appendChild(document.createTextNode(o("showAll"))),n.href="#",n.onclick=function(i){return t.visibleChilds=1/0,e.updateDom(),t.showChilds(),i.preventDefault(),!1};var r=document.createElement("div"),s=document.createTextNode(this._getShowMoreText());r.className="jsoneditor-show-more",r.appendChild(s),r.appendChild(i),r.appendChild(document.createTextNode(". ")),r.appendChild(n),r.appendChild(document.createTextNode(". "));var a=document.createElement("td");a.appendChild(r);var l=document.createElement("tr");l.appendChild(document.createElement("td")),l.appendChild(document.createElement("td")),l.appendChild(a),l.className="jsoneditor-show-more",this.dom.tr=l,this.dom.moreContents=r,this.dom.moreText=s}return this.updateDom(),this.dom.tr},t.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},t.prototype._getShowMoreText=function(){return o("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},t.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},t.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},t}var o=i(8).translate;e.exports=n},function(e,t,i){function n(e,t){var i='<div class="pico-modal-contents"><div class="pico-modal-header">'+r("sort")+"</div><form><table><tbody><tr>  <td>"+r("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+r("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+r("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+r("sortAscending")+'" title="'+r("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+r("sortDescending")+'" title="'+r("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+r("ok")+'" /></td></tr></tbody></table></form></div>';o({parent:t,content:i,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){function i(e){s.value=e,s.className="jsoneditor-button-group jsoneditor-button-group-value-"+s.value}var n=t.modalElem().querySelector("form"),o=t.modalElem().querySelector("#ok"),r=t.modalElem().querySelector("#field"),s=t.modalElem().querySelector("#direction"),a="array"===e.type?e.getChildPaths():["."];a.forEach(function(e){var t=document.createElement("option");t.text=e,t.value=e,r.appendChild(t)}),r.value=e.sortedBy?e.sortedBy.path:a[0],i(e.sortedBy?e.sortedBy.direction:"asc"),s.onclick=function(e){i(e.target.getAttribute("data-value"))},o.onclick=function(i){i.preventDefault(),i.stopPropagation(),t.close();var n=r.value,o="."===n?[]:n.split(".").slice(1);e.sortedBy={path:n,direction:s.value},e.sort(o,s.value)},n&&(n.onsubmit=o.onclick)}).afterClose(function(e){e.destroy()}).show()}var o=i(16),r=i(8).translate;e.exports=n},function(e,t,i){var n,o,r;!function(i,s){"use strict";o=[],n=s,void 0!==(r="function"==typeof n?n.apply(t,o):n)&&(e.exports=r)}(0,function(){"use strict";function e(e){return"object"==typeof Node?e instanceof Node:e&&"object"==typeof e&&"number"==typeof e.nodeType}function t(e){return"string"==typeof e}function i(){var e=[];return{watch:e.push.bind(e),trigger:function(t,i){for(var n=!0,o={detail:i,preventDefault:function(){n=!1}},r=0;r<e.length;r++)e[r](t,o);return n}}}function n(e){return"none"===window.getComputedStyle(e).display}function o(e){this.elem=e}function r(e,t){return o.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}function s(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+d++);return o.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new o(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function a(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function l(e){return function(){return e().elem}}function c(e,t){function i(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function o(e){return!(n(e)||i(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||i(e,"input,select,textarea,button,a[href],area[href],iframe"))}function r(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(o(t[i]))return t[i]}function s(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}var a;e.beforeShow(function(){a=document.activeElement}),e.afterShow(function(){if(t()){var i=r(e.modalElem());i&&i.focus()}}),e.afterClose(function(){t()&&a&&a.focus(),a=null}),p.watch(function(i){if(t()&&e.isVisible()){var n=r(e.modalElem()),o=s(e.modalElem());(i.shiftKey?n:o)===document.activeElement&&((i.shiftKey?o:n).focus(),i.preventDefault())}})}function h(e,t){var i,n=new o(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}o.make=function(e,t){"string"==typeof e&&(e=document.querySelector(e));var i=document.createElement(t||"div");return(e||document.body).appendChild(i),new o(i)},o.prototype={child:function(e){return o.make(this.elem,e)},stylize:function(e){e=e||{},void 0!==e.opacity&&(e.filter="alpha(opacity="+100*e.opacity+")");for(var t in e)e.hasOwnProperty(t)&&(this.elem.style[t]=e[t]);return this},clazz:function(e){return this.elem.className+=" "+e,this},html:function(t){return e(t)?this.elem.appendChild(t):this.elem.innerHTML=t,this},onClick:function(e){return this.elem.addEventListener("click",e),this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){return void 0!==t&&this.elem.setAttribute(e,t),this},anyAncestor:function(e){for(var t=this.elem;t;){if(e(new o(t)))return!0;t=t.parentNode}return!1},isVisible:function(){return!n(this.elem)}};var d=1,u=i(),p=i();return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?u.trigger():9===t&&p.trigger(e)}),function(n){function o(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}function d(e){E().hide(),C().hide(),_.trigger(g,e)}function p(e){w.trigger(g,e)&&d(e)}function f(e){return function(){return e.apply(this,arguments),g}}function m(e,t){if(!v){var i=s(o,p);v={modal:i,overlay:r(o,p),close:a(i,o)},y.trigger(g,t)}return v[e]}(t(n)||e(n))&&(n={content:n});var g,v,y=i(),b=i(),x=i(),w=i(),_=i(),C=m.bind(window,"modal"),E=m.bind(window,"overlay"),S=m.bind(window,"close");return g={modalElem:l(C),closeElem:l(S),overlayElem:l(E),buildDom:f(m.bind(null,null)),isVisible:function(){return!!(v&&C&&C().isVisible())},show:function(e){return b.trigger(g,e)&&(E().show(),S(),C().show(),x.trigger(g,e)),this},close:f(p),forceClose:f(d),destroy:function(){C().destroy(),E().destroy(),E=C=S=void 0},options:function(e){Object.keys(e).map(function(t){n[t]=e[t]})},afterCreate:f(y.watch),beforeShow:f(b.watch),afterShow:f(x.watch),beforeClose:f(w.watch),afterClose:f(_.watch)},c(g,o.bind(null,"focus",!0)),h(g,o.bind(null,"bodyOverflow",!0)),u.watch(function(){o("escCloses",!0)&&g.isVisible()&&g.close()}),g}})},function(e,t,i){function n(e,t){var i=e.getValue(),n='<label class="pico-modal-contents"><div class="pico-modal-header">'+a("transform")+'</div><p>Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.</p><table><tbody><tr>  <th>'+a("transformWizardLabel")+' </th>  <td>  <div id="wizard" class="jsoneditor-jmespath-wizard">  <div>    <div class="jsoneditor-jmespath-wizard-label">'+a("transformWizardFilter")+'</div>    <div class="jsoneditor-jmespath-filter">      <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >        <select id="filterField">        </select>      </div>      <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >        <select id="filterRelation">          <option value="==">==</option>          <option value="!=">!=</option>          <option value="<">&lt;</option>          <option value="<=">&lt;=</option>          <option value=">">&gt;</option>          <option value=">=">&gt;=</option>        </select>      </div>      <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >        <input placeholder="value..." id="filterValue" />      </div>    </div>  </div>  <div>    <div class="jsoneditor-jmespath-wizard-label">'+a("transformWizardSortBy")+'</div>    <div class="jsoneditor-jmespath-filter">      <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">        <select id="sortField">        </select>      </div>      <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >        <select id="sortOrder">          <option value="asc">Ascending</option>          <option value="desc">Descending</option>        </select>      </div>    </div>  </div>  <div id="selectFieldsPart">    <div class="jsoneditor-jmespath-wizard-label">'+a("transformWizardSelectFields")+'</div>    <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple>    </select>  </div>  </div>  </td></tr><tr>  <th>'+a("transformQueryLabel")+' </th>  <td class="jsoneditor-modal-input">    <textarea id="query"               rows="4"               autocomplete="off"               autocorrect="off"               autocapitalize="off"               spellcheck="false"              title="'+a("transformQueryTitle")+'">[*]</textarea>  </td></tr><tr>  <th>'+a("transformPreviewLabel")+' </th>  <td class="jsoneditor-modal-input">    <textarea id="preview"         class="jsoneditor-transform-preview"        readonly> </textarea>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+a("ok")+'" autofocus /></td></tr></tbody></table></div>';r({parent:t,content:n,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){function n(e){return"."===e[0]?"."===e?"@":e.slice(1):e}function r(){if(p.value&&f.value&&m.value){var t=p.value,i=JSON.stringify(e._stringCast(m.value));b.value="[? "+t+" "+f.value+" `"+i+"`]"}else b.value="[*]";if(g.value&&v.value){var n=g.value;"desc"===v.value?b.value+=" | reverse(sort_by(@, &"+n+"))":b.value+=" | sort_by(@, &"+n+")"}if(y.value){for(var o=[],r=0;r<y.options.length;r++)if(y.options[r].selected){var s=y.options[r].value;o.push(s)}"]"!==b.value[b.value.length-1]&&(b.value+=" | [*]"),1===o.length?b.value+="."+s:o.length>1&&(b.value+=".{"+o.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")}N()}function a(){try{var e=o.search(i,b.value),t=JSON.stringify(e,null,2).split("\n");t.length>c&&(t=t.slice(0,c).concat(["..."])),x.className="jsoneditor-transform-preview",x.value=t.join("\n"),u.disabled=!1}catch(e){x.className="jsoneditor-transform-preview jsoneditor-error",x.value=e.toString(),u.disabled=!0}}var h=t.modalElem(),d=h.querySelector("#wizard"),u=h.querySelector("#ok"),p=h.querySelector("#filterField"),f=h.querySelector("#filterRelation"),m=h.querySelector("#filterValue"),g=h.querySelector("#sortField"),v=h.querySelector("#sortOrder"),y=h.querySelector("#selectFields"),b=h.querySelector("#query"),x=h.querySelector("#preview");Array.isArray(i)||(d.style.display="none",d.parentNode.style.fontStyle="italic",d.parentNode.appendChild(document.createTextNode("(wizard not available for objects, only for arrays)"))),e.getChildPaths().forEach(function(e){var t=n(e),i=document.createElement("option");i.text=t,i.value=t,p.appendChild(i);var o=document.createElement("option");o.text=t,o.value=t,g.appendChild(o)});var w=e.getChildPaths(!0).filter(function(e){return"."!==e});w.length>0?w.forEach(function(e){var t=n(e),i=document.createElement("option");i.text=t,i.value=t,y.appendChild(i)}):h.querySelector("#selectFieldsPart").style.display="none";var _=new s(p,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),C=new s(f,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),E=new s(g,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),S=new s(v,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),j=new s(y,{multiple:!0,clearable:!0,defaultSelected:!1});_.on("selectr.change",r),C.on("selectr.change",r),m.oninput=r,E.on("selectr.change",r),S.on("selectr.change",r),j.on("selectr.change",r),d.onclick=function(e){e.preventDefault()},b.value=Array.isArray(i)?"[*]":"@";var N=l(a,300);b.oninput=N,N(),u.onclick=function(i){i.preventDefault(),i.stopPropagation(),t.close(),e.transform(b.value)},setTimeout(function(){b.select(),b.focus(),b.selectionStart=3,b.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}var o=i(11),r=i(16),s=i(18),a=i(8).translate,l=i(4).debounce,c=100;e.exports=n},function(e,t){"use strict";function i(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function n(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),s.removeClass(e,"excluded"),i||(e.innerHTML=e.textContent)}var o={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."},r=function(){};r.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},r.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=r.prototype[t[i]]:e[t[i]]=r.prototype[t[i]];return e};var s={extend:function(e,t){t=t||{};var i;for(i in e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var o=0,r=e.length;o<r;o++)t.call(i,o,e[o],e)},createElement:function(e,t){var i=document,n=i.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t)){var o;for(o in t)if(o in n)n[o]=t[o];else if("html"===o)n.innerHTML=t[o];else if("text"===o){var r=i.createTextNode(t[o]);n.appendChild(r)}else n.setAttribute(o,t[o])}return n},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){s.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){s.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:s.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(e,t,i){var n;return function(){var o=this,r=arguments,s=function(){n=null,i||e.apply(o,r)},a=i&&!n;clearTimeout(n),n=setTimeout(s,t),a&&e.apply(o,r)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),o=t?i.pageXOffset:0,r=t?i.pageYOffset:0;return{bottom:n.bottom+r,height:n.height,left:n.left+o,right:n.right+o,top:n.top+r,width:n.width}},includes:function(e,t){return e.indexOf(t)>-1},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}},a=function(){if(this.items.length){var e=document.createDocumentFragment();if(this.config.pagination){var t=this.pages.slice(0,this.pageIndex);s.each(t,function(t,i){s.each(i,function(t,i){n(i,e,this.customOption)},this)},this)}else s.each(this.items,function(t,i){n(i,e,this.customOption)},this);e.childElementCount&&(s.removeClass(this.items[this.navIndex],"active"),this.navIndex=e.querySelector(".selectr-option").idx,s.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(e)}},l=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!s.hasClass(this.container,"notice")||this.close()},c=function(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=s.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,s.addClass(n,"disabled")),n},h=function(){this.requiresPagination=this.config.pagination&&this.config.pagination>0,i(this.config,"width")&&(s.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":s.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=s.createElement("div",{class:"selectr-container"}),this.config.customClass&&s.addClass(this.container,this.config.customClass),this.mobileDevice?s.addClass(this.container,"selectr-mobile"):s.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?s.addClass(this.el,"selectr-visible"):s.addClass(this.el,"selectr-hidden"),this.selected=s.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=s.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=s.createElement("div",{class:"selectr-options-container"});if(this.tree=s.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=s.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(s.addClass(this.label,"selectr-tags"),s.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=s.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),s.addClass(this.container,"clearable")),this.config.taggable){var t=s.createElement("li",{class:"input-tag"});this.input=s.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),s.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=s.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=s.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=s.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var n=!1,o=0;if(this.el.children.length&&s.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(n=s.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),s.each(t.children,function(e,t){t.idx=o,n.appendChild(c.call(this,t,n)),o++},this)):(t.idx=o,c.call(this,t),o++)},this),this.config.data&&Array.isArray(this.config.data)){this.data=[];var r,a=!1;n=!1,o=0,s.each(this.config.data,function(e,t){i(t,"children")?(a=s.createElement("optgroup",{label:t.text}),n=s.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),s.each(t.children,function(e,t){r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected),r.disabled=i(t,"disabled"),this.options.push(r),a.appendChild(r),r.idx=o,n.appendChild(c.call(this,r,t)),this.data[o]=t,o++},this)):(r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected),r.disabled=i(t,"disabled"),this.options.push(r),r.idx=o,c.call(this,r,t),this.data[o]=t,o++)},this)}this.setSelected(!0);var l;this.navIndex=0;for(var h=0;h<this.items.length;h++)if(l=this.items[h],!s.hasClass(l,"disabled")){s.addClass(l,"active"),this.navIndex=h;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=s.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)},d=function(e){if(e=e||window.event,!this.items.length||!this.opened||!s.includes([13,38,40],e.which))return void(this.navigating=!1);if(e.preventDefault(),13===e.which)return!(this.config.taggable&&this.input.value.length>0)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:t=0,this.navIndex>0&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;s.hasClass(this.items[this.navIndex],"disabled")||s.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=s.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&f.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&s.removeClass(i,"active"),s.addClass(this.items[this.navIndex],"active")},u=function(e){var t,i=this,n=document.createDocumentFragment(),o=this.options[e.idx],r=this.data?this.data[e.idx]:o,a=this.customSelected?this.config.renderSelection(r):o.textContent,l=s.createElement("li",{class:"selectr-tag",html:a}),c=s.createElement("button",{class:"selectr-tag-remove",type:"button"});if(l.appendChild(c),l.idx=e.idx,l.tag=o.value,this.tags.push(l),this.config.sortSelected){var h=this.tags.slice();t=function(e,t){e.replace(/(\d+)|(\D+)/g,function(e,i,n){t.push([i||1/0,n||""])})},h.sort(function(e,n){var o,r,s=[],a=[];for(!0===i.config.sortSelected?(o=e.tag,r=n.tag):"text"===i.config.sortSelected&&(o=e.textContent,r=n.textContent),t(o,s),t(r,a);s.length&&a.length;){var l=s.shift(),c=a.shift(),h=l[0]-c[0]||l[1].localeCompare(c[1]);if(h)return h}return s.length-a.length}),s.each(h,function(e,t){n.appendChild(t)}),this.label.innerHTML=""}else n.appendChild(l);this.config.taggable?this.label.insertBefore(n,this.input.parentNode):this.label.appendChild(n)},p=function(e){var t=!1;s.each(this.tags,function(i,n){n.idx===e.idx&&(t=n)},this),t&&(this.label.removeChild(t),this.tags.splice(this.tags.indexOf(t),1))},f=function(){var e=this.tree;if(e.scrollTop>=e.scrollHeight-e.offsetHeight&&this.pageIndex<this.pages.length){var t=document.createDocumentFragment();s.each(this.pages[this.pageIndex],function(e,i){n(i,t,this.customOption)},this),e.appendChild(t),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}},m=function(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&s.removeClass(this.inputContainer,"active"),s.hasClass(this.container,"notice")&&(s.removeClass(this.container,"notice"),s.addClass(this.container,"open"),this.input.focus()),s.each(this.items,function(e,t){s.removeClass(t,"excluded"),this.customOption||(t.innerHTML=t.textContent)},this))},g=function(e,t){var i=new RegExp(e,"i").exec(t.textContent);return!!i&&t.textContent.replace(i[0],"<span class='selectr-match'>"+i[0]+"</span>")},v=function(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if(this.el=e,"string"==typeof e&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)};v.prototype.render=function(e){if(!this.rendered){this.config=s.extend(o,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=i(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,r.mixin(this),h.call(this),this.bindEvents(),this.update(),this.optsRect=s.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var t=this;setTimeout(function(){t.emit("selectr.init")},20)}},v.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},v.prototype.getSelectedProperties=function(e){var t=this.getSelected();return[].slice.call(t).map(function(t){return t[e]}).filter(function(e){return null!==e&&void 0!==e})},v.prototype.bindEvents=function(){var e=this;if(this.events={},this.events.dismiss=l.bind(this),this.events.navigate=d.bind(this),this.events.reset=this.reset.bind(this),this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(t){t.changedTouches[0].target===e.el&&e.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(t){t.preventDefault(),t.stopPropagation(),t.target===e.el&&e.toggle()});var t=function(e,t){for(var i,n=[],o=e.slice(0),r=0;r<t.length;r++)i=o.indexOf(t[r]),i>-1?o.splice(i,1):n.push(t[r]);return[n,o]};this.el.addEventListener("change",function(i){if(e.el.multiple){var n=e.getSelectedProperties("idx"),o=t(e.selectedIndexes,n);s.each(o[0],function(t,i){e.select(i)},e),s.each(o[1],function(t,i){e.deselect(i)},e)}else e.el.selectedIndex>-1&&e.select(e.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(t){"Enter"===t.key&&e.selected===document.activeElement&&(e.toggle(),setTimeout(function(){e.el.focus()},200))}),this.selected.addEventListener("click",function(t){e.disabled||e.toggle(),t.preventDefault(),t.stopPropagation()}),this.label.addEventListener("click",function(t){s.hasClass(t.target,"selectr-tag-remove")&&e.deselect(t.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(t){t.preventDefault(),t.stopPropagation();var i=s.closest(t.target,function(e){return e&&s.hasClass(e,"selectr-option")});i&&(s.hasClass(i,"disabled")||(s.hasClass(i,"selected")?(e.el.multiple||!e.el.multiple&&e.config.allowDeselect)&&e.deselect(i.idx):e.select(i.idx),e.opened&&!e.el.multiple&&e.close()))}),this.tree.addEventListener("mouseover",function(t){s.hasClass(t.target,"selectr-option")&&(s.hasClass(t.target,"disabled")||(s.removeClass(e.items[e.navIndex],"active"),s.addClass(t.target,"active"),e.navIndex=[].slice.call(e.items).indexOf(t.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(t){e.searching=!0}),this.input.addEventListener("blur",function(t){e.searching=!1}),this.input.addEventListener("keyup",function(t){e.search(),e.config.taggable||(this.value.length?s.addClass(this.parentNode,"active"):s.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(t){e.input.value=null,m.call(e),e.tree.childElementCount||a.call(e)})),this.config.taggable&&this.input.addEventListener("keyup",function(t){if(e.search(),e.config.taggable&&this.value.length){var i=this.value.trim();if(13===t.which||s.includes(e.tagSeperators,t.key)){s.each(e.tagSeperators,function(e,t){i=i.replace(t,"")});e.add({value:i,text:i,selected:!0},!0)?(e.close(),m.call(e)):(this.value="",e.setMessage("That tag is already in use."))}}}),this.update=s.debounce(function(){e.opened&&e.config.closeOnScroll&&e.close(),e.width&&(e.container.style.width=e.width),e.invert()},50),this.requiresPagination&&(this.paginateItems=s.debounce(function(){f.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},v.prototype.setSelected=function(e){if(this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,this.selectedIndex>-1&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),s.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data){!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0);var t=0;s.each(this.config.data,function(e,n){i(n,"children")?s.each(n.children,function(e,i){i.hasOwnProperty("selected")&&!0===i.selected&&this.select(t),t++},this):(n.hasOwnProperty("selected")&&!0===n.selected&&this.select(t),t++)},this)}},v.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),s.removeClass(this.el,"selectr-hidden"),this.el.form&&s.off(this.el.form,"reset",this.events.reset),s.off(document,"click",this.events.dismiss),s.off(document,"keydown",this.events.navigate),s.off(window,"resize",this.update),s.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},v.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&s.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},v.prototype.select=function(e){var t=this.items[e],i=[].slice.call(this.el.options),n=this.options[e];if(this.el.multiple){if(s.includes(this.selectedIndexes,e))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(n.value),this.selectedIndexes.push(e),u.call(this,t)}else{var o=this.data?this.data[e]:n;this.label.innerHTML=this.customSelected?this.config.renderSelection(o):n.textContent,this.selectedValue=n.value,this.selectedIndex=e,s.each(this.options,function(t,i){var n=this.items[t];t!==e&&(n&&s.removeClass(n,"selected"),i.selected=!1,i.removeAttribute("selected"))},this)}s.includes(i,n)||this.el.add(n),t.setAttribute("aria-selected",!0),s.addClass(t,"selected"),s.addClass(this.container,"has-selected"),n.selected=!0,n.setAttribute("selected",""),this.emit("selectr.change",n),this.emit("selectr.select",n)},v.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var o=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(o,1);var r=this.selectedValues.indexOf(n.value);this.selectedValues.splice(r,1),p.call(this,i),this.tags.length||s.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,s.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),s.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},v.prototype.setValue=function(e){var t=Array.isArray(e);if(t||(e=e.toString().trim()),!this.el.multiple&&t)return!1;s.each(this.options,function(i,n){(t&&s.includes(e.toString(),n.value)||n.value===e)&&this.change(n.idx)},this)},v.prototype.getValue=function(e,t){var i;if(this.el.multiple)e?this.selectedIndexes.length&&(i={},i.values=[],s.each(this.selectedIndexes,function(e,t){var n=this.options[t];i.values[e]={value:n.value,text:n.textContent}},this)):i=this.selectedValues.slice();else if(e){var n=this.options[this.selectedIndex];i={value:n.value,text:n.textContent}}else i=this.selectedValue;return e&&t&&(i=JSON.stringify(i)),i},v.prototype.add=function(e,t){if(e){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(e))s.each(e,function(e,i){this.add(i,t)},this);else if("[object Object]"===Object.prototype.toString.call(e)){if(t){var i=!1;if(s.each(this.options,function(t,n){n.value.toLowerCase()===e.value.toLowerCase()&&(i=!0)}),i)return!1}var n=s.createElement("option",e);return this.data.push(e),this.options.push(n),n.idx=this.options.length>0?this.options.length-1:0,c.call(this,n),e.selected&&this.select(n.idx),n}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},v.prototype.remove=function(e){var t=[];if(Array.isArray(e)?s.each(e,function(i,n){s.isInt(n)?t.push(this.getOptionByIndex(n)):"string"==typeof e&&t.push(this.getOptionByValue(n))},this):s.isInt(e)?t.push(this.getOptionByIndex(e)):"string"==typeof e&&t.push(this.getOptionByValue(e)),t.length){var i;s.each(t,function(e,t){i=t.idx,this.el.remove(t),this.options.splice(i,1);var n=this.items[i].parentNode;n&&n.removeChild(this.items[i]),this.items.splice(i,1),s.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate()}},v.prototype.removeAll=function(){this.clear(!0),s.each(this.el.options,function(e,t){this.el.remove(t)},this),s.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},v.prototype.search=function(e){if(!this.navigating){e=e||this.input.value;var t=document.createDocumentFragment();if(this.removeMessage(),s.truncate(this.tree),e.length>1)if(s.each(this.options,function(i,o){var r=this.items[o.idx];s.includes(o.textContent.toLowerCase(),e.toLowerCase())&&!o.disabled?(n(r,t,this.customOption),s.removeClass(r,"excluded"),this.customOption||(r.innerHTML=g(e,o))):s.addClass(r,"excluded")},this),t.childElementCount){var i=this.items[this.navIndex],o=t.firstElementChild;s.removeClass(i,"active"),this.navIndex=o.idx,s.addClass(o,"active")}else this.config.taggable||this.setMessage("no results.");else a.call(this);this.tree.appendChild(t)}},v.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},v.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(s.addClass(this.container,"native-open"),void(this.config.data&&s.each(this.options,function(e,t){this.el.add(t)},this))):(s.addClass(this.container,"open"),a.call(this),this.invert(),this.tree.scrollTop=0,s.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},v.prototype.close=function(){if(this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown)return void s.removeClass(this.container,"native-open");var e=s.hasClass(this.container,"notice");this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(s.removeClass(this.container,"notice"),this.notice.textContent=""),s.removeClass(this.container,"open"),s.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),s.truncate(this.tree),m.call(this)},v.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&s.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),s.removeClass(this.container,"selectr-disabled")},v.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&s.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,s.addClass(this.container,"selectr-disabled")},v.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),s.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},v.prototype.clear=function(e){if(this.el.multiple){if(this.selectedIndexes.length){var t=this.selectedIndexes.slice();s.each(t,function(e,t){this.deselect(t)},this)}}else this.selectedIndex>-1&&this.deselect(this.selectedIndex,e);this.emit("selectr.clear")},v.prototype.serialise=function(e){var t=[];return s.each(this.options,function(e,i){var n={value:i.value,text:i.textContent};i.selected&&(n.selected=!0),i.disabled&&(n.disabled=!0),t[e]=n}),e?JSON.stringify(t):t},v.prototype.serialize=function(e){return this.serialise(e)},v.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.innerHTML=e},v.prototype.paginate=function(){if(this.items.length){var e=this;return this.pages=this.items.map(function(t,i){return i%e.config.pagination==0?e.items.slice(i,i+e.config.pagination):null}).filter(function(e){return e}),this.pages}},v.prototype.setMessage=function(e,t){t&&this.close(),s.addClass(this.container,"notice"),this.notice.textContent=e},v.prototype.removeMessage=function(){s.removeClass(this.container,"notice"),this.notice.innerHTML=""},v.prototype.invert=function(){var e=s.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(s.addClass(this.container,"inverted"),this.isInverted=!0):(s.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=s.rect(this.tree)},v.prototype.getOptionByIndex=function(e){return this.options[e]},v.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=v},function(e,t,i){"use strict";function n(e,t,i,n){for(var r={code:{text:"Code",title:"Switch to code highlighter",click:function(){n("code")}},form:{text:"Form",title:"Switch to form editor",click:function(){n("form")}},text:{text:"Text",title:"Switch to plain text editor",click:function(){n("text")}},tree:{text:"Tree",title:"Switch to tree editor",click:function(){n("tree")}},view:{text:"View",title:"Switch to tree view",click:function(){n("view")}}},s=[],a=0;a<t.length;a++){var l=t[a],c=r[l];if(!c)throw new Error('Unknown mode "'+l+'"');c.className="jsoneditor-type-modes"+(i==l?" jsoneditor-selected":""),s.push(c)}var h=r[i];if(!h)throw new Error('Unknown mode "'+i+'"');var d=h.text,u=document.createElement("button");u.type="button",u.className="jsoneditor-modes jsoneditor-separator",u.innerHTML=d+" &#x25BE;",u.title="Switch editor mode",u.onclick=function(){new o(s).show(u)};var p=document.createElement("div");p.className="jsoneditor-modes",p.style.position="relative",p.appendChild(u),e.appendChild(p),this.dom={container:e,box:u,frame:p}}var o=i(7);n.prototype.focus=function(){this.dom.box.focus()},n.prototype.destroy=function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null},e.exports=n},function(e,t){"use strict";function i(e){function t(e){var t,i;document.createRange?(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),i=window.getSelection(),i.removeAllRanges(),i.addRange(t)):document.selection&&(t=document.body.createTextRange(),t.moveToElementText(e),t.collapse(!1),t.select())}function i(e){return void 0===a&&(a=document.createElement("span"),a.style.visibility="hidden",a.style.position="fixed",a.style.outline="0",a.style.margin="0",a.style.padding="0",a.style.border="0",a.style.left="0",a.style.whiteSpace="pre",a.style.fontSize=n,a.style.fontFamily=o,a.style.fontWeight="normal",document.body.appendChild(a)),a.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),a.getBoundingClientRect().right}e=e||{},e.confirmKeys=e.confirmKeys||[39,35,9],e.caseSensitive=e.caseSensitive||!1;var n="",o="",r=document.createElement("div");r.style.position="relative",r.style.outline="0",r.style.border="0",r.style.margin="0",r.style.padding="0";var s=document.createElement("div");s.className="autocomplete dropdown",s.style.position="absolute",s.style.visibility="hidden";var a,l,c={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:r,show:function(e,t,i){this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""==n&&(n=window.getComputedStyle(e).getPropertyValue("font-size")),""==o&&(o=window.getComputedStyle(e).getPropertyValue("font-family"));e.getBoundingClientRect().right,e.getBoundingClientRect().left;s.style.marginLeft="0",s.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i,this.element!=e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){this.element.focus()}.bind(this),this.element.addEventListener&&(this.element.removeEventListener("keydown",d),this.element.addEventListener("keydown",d,!1),this.element.removeEventListener("blur",u),this.element.addEventListener("blur",u,!1)),r.appendChild(this.elementHint),r.appendChild(s),e.parentElement.appendChild(r),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,h.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(t){var n=t.innerText;n=n.replace("\n","");var o=(this.startFrom,this.options,this.options.length),r=n.substring(this.startFrom);l=n.substring(0,this.startFrom);for(var a=0;a<o;a++){var c=this.options[a];if(!e.caseSensitive&&0===c.toLowerCase().indexOf(r.toLowerCase())||e.caseSensitive&&0===c.indexOf(r)){this.elementHint.innerText=l+r+c.substring(r.length),this.elementHint.realInnerText=l+c;break}}s.style.left=i(l)+"px",h.refresh(r,this.options),this.elementHint.style.width=i(this.elementHint.innerText)+10+"px","hidden"==s.style.visibility||(this.elementHint.style.width=i(this.elementHint.innerText)+s.clientWidth+"px")}},h=function(t,i){var n=[],o=0,r=-1,s=function(){this.style.outline="1px solid #ddd"},a=function(){this.style.outline="0"},l=function(){c.hide(),c.onmouseselection(this.__hint,c.rs)},c={rs:i,hide:function(){t.style.visibility="hidden"},refresh:function(i,r){t.style.visibility="hidden",o=0,t.innerHTML="";var h=window.innerHeight||document.documentElement.clientHeight,d=t.parentNode.getBoundingClientRect(),u=d.top-6,p=h-d.bottom-6;n=[];for(var f=0;f<r.length;f++)if(!(e.caseSensitive&&0!==r[f].indexOf(i)||!e.caseSensitive&&0!==r[f].toLowerCase().indexOf(i.toLowerCase()))){var m=document.createElement("div");m.className="item",m.onmouseover=s,m.onmouseout=a,m.onmousedown=l,m.__hint=r[f],m.innerHTML=r[f].substring(0,i.length)+"<b>"+r[f].substring(i.length)+"</b>",n.push(m),t.appendChild(m)}0!==n.length&&(1===n.length&&(i.toLowerCase()===n[0].__hint.toLowerCase()&&!e.caseSensitive||i===n[0].__hint&&e.caseSensitive)||n.length<2||(c.highlight(0),u>3*p?(t.style.maxHeight=u+"px",t.style.top="",t.style.bottom="100%"):(t.style.top="100%",t.style.bottom="",t.style.maxHeight=p+"px"),t.style.visibility="visible"))},highlight:function(e){-1!=r&&n[r]&&(n[r].className="item"),n[e].className="item hover",r=e},move:function(e){return"hidden"===t.style.visibility?"":o+e===-1||o+e===n.length?n[o].__hint:(o+=e,c.highlight(o),n[o].__hint)},onmouseselection:function(){}};return c}(s,c),d=function(i){i=i||window.event;var n=i.keyCode;if(null!=this.elementHint&&33!=n&&34!=n){if(27==n)return c.hideDropDown(),c.element.focus(),i.preventDefault(),void i.stopPropagation();var o=this.element.innerText;o=o.replace("\n","");this.startFrom;if(e.confirmKeys.indexOf(n)>=0)return 9==n&&0==this.elementHint.innerText.length&&c.onTab(),void(this.elementHint.innerText.length>0&&this.element.innerText!=this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,c.hideDropDown(),t(this.element),9==n&&(c.element.focus(),i.preventDefault(),i.stopPropagation())));if(13!=n){if(40==n){var r=o.substring(this.startFrom),a=h.move(1);return""==a&&c.onArrowDown(),this.elementHint.innerText=l+r+a.substring(r.length),this.elementHint.realInnerText=l+a,i.preventDefault(),void i.stopPropagation()}if(38==n){var r=o.substring(this.startFrom),a=h.move(-1);return""==a&&c.onArrowUp(),this.elementHint.innerText=l+r+a.substring(r.length),this.elementHint.realInnerText=l+a,i.preventDefault(),void i.stopPropagation()}}else if(0==this.elementHint.innerText.length)c.onEnter();else{var d="hidden"==s.style.visibility;if(h.hide(),d)return c.hideDropDown(),c.element.focus(),void c.onEnter();this.element.innerText=this.elementHint.realInnerText,c.hideDropDown(),t(this.element),i.preventDefault(),i.stopPropagation()}}}.bind(c),u=function(e){c.hideDropDown()}.bind(c);return h.onmouseselection=function(e,i){i.element.innerText=i.elementHint.innerText=l+e,i.hideDropDown(),window.setTimeout(function(){i.element.focus(),t(i.element)},1)},c}e.exports=i},function(e,t,i){"use strict";var n=i(22),o=i(19),r=i(4),s={};s.create=function(e,t){t=t||{},void 0===t.statusBar&&(t.statusBar=!0),this.options=t,t.indentation?this.indentation=Number(t.indentation):this.indentation=2;var s=t.ace?t.ace:n;if(this.mode="code"==t.mode?"code":"text","code"==this.mode&&void 0===s&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||"ace/theme/jsoneditor","ace/theme/jsoneditor"===this.theme&&s)try{i(26)}catch(e){console.error(e)}t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var a=this;this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this._debouncedValidate=r.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var l=document.createElement("button");l.type="button",l.className="jsoneditor-format",l.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(l),l.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}};var c=document.createElement("button");c.type="button",c.className="jsoneditor-compact",c.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(c),c.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}};var h=document.createElement("button");h.type="button",h.className="jsoneditor-repair",h.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(h),h.onclick=function(){try{a.repair(),a._onChange()}catch(e){a._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new o(this.menu,this.options.modes,this.options.mode,function(e){a.setMode(e),a.modeSwitcher.focus()}));var d={},u=this.options.onEditable&&typeof("function"===this.options.onEditable)&&!this.options.onEditable(d);if(this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"==this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var p=s.edit(this.editorDom);p.$blockScrolling=1/0,p.setTheme(this.theme),p.setOptions({readOnly:u}),p.setShowPrintMargin(!1),p.setFontSize(13),p.getSession().setMode("ace/mode/json"),p.getSession().setTabSize(this.indentation),p.getSession().setUseSoftTabs(!0),p.getSession().setUseWrapMode(!0),p.commands.bindKey("Ctrl-L",null),p.commands.bindKey("Command-L",null),this.aceEditor=p,this.hasOwnProperty("editor")||Object.defineProperty(this,"editor",{get:function(){return console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor},set:function(e){console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor=e}});var f=document.createElement("a");f.appendChild(document.createTextNode("powered by ace")),f.href="http://ace.ajax.org",f.target="_blank",f.className="jsoneditor-poweredBy",f.onclick=function(){window.open(f.href,f.target)},this.menu.appendChild(f),p.on("change",this._onChange.bind(this)),p.on("changeSelection",this._onSelect.bind(this))}else{var m=document.createElement("textarea");m.className="jsoneditor-text",m.spellcheck=!1,this.content.appendChild(m),this.textarea=m,this.textarea.readOnly=u,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),m.onselect=this._onSelect.bind(this),m.onmousedown=this._onMouseDown.bind(this),m.onblur=this._onBlur.bind(this)}var g=document.createElement("div");if(g.className="validation-errors-container",this.dom.validationErrorsContainer=g,this.frame.appendChild(g),t.statusBar){r.addClassName(this.content,"has-status-bar"),this.curserInfoElements={};var v=document.createElement("div");this.dom.statusBar=v,v.className="jsoneditor-statusbar",this.frame.appendChild(v);var y=document.createElement("span");y.className="jsoneditor-curserinfo-label",y.innerText="Ln:";var b=document.createElement("span");b.className="jsoneditor-curserinfo-val",b.innerText="1",v.appendChild(y),v.appendChild(b);var x=document.createElement("span");x.className="jsoneditor-curserinfo-label",x.innerText="Col:";var w=document.createElement("span");w.className="jsoneditor-curserinfo-val",w.innerText="1",v.appendChild(x),v.appendChild(w),this.curserInfoElements.colVal=w,this.curserInfoElements.lnVal=b;var _=document.createElement("span");_.className="jsoneditor-curserinfo-label",_.innerText="characters selected",_.style.display="none";var C=document.createElement("span");C.className="jsoneditor-curserinfo-count",C.innerText="0",C.style.display="none",this.curserInfoElements.countLabel=_,this.curserInfoElements.countVal=C,v.appendChild(C),v.appendChild(_)}this.setSchema(this.options.schema,this.options.schemaRefs)},s._onChange=function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}},s._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},s._onKeyDown=function(e){var t=e.which||e.keyCode,i=!1;220==t&&e.ctrlKey&&(e.shiftKey?(this.compact(),this._onChange()):(this.format(),this._onChange()),i=!0),i&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},s._onMouseDown=function(e){this._updateCursorInfo(),this._emitSelectionChange()},s._onBlur=function(e){this._updateCursorInfo(),this._emitSelectionChange()},s._updateCursorInfo=function(){function e(){o.curserInfoElements.countVal.innerText!==n&&(o.curserInfoElements.countVal.innerText=n,o.curserInfoElements.countVal.style.display=n?"inline":"none",o.curserInfoElements.countLabel.style.display=n?"inline":"none"),o.curserInfoElements.lnVal.innerText=t,o.curserInfoElements.colVal.innerText=i}var t,i,n,o=this;if(this.textarea)setTimeout(function(){var s=r.getInputSelection(o.textarea);s.startIndex!==s.endIndex&&(n=s.endIndex-s.startIndex),n&&o.cursorInfo&&o.cursorInfo.line===s.end.row&&o.cursorInfo.column===s.end.column?(t=s.start.row,i=s.start.column):(t=s.end.row,i=s.end.column),o.cursorInfo={line:t,column:i,count:n},o.options.statusBar&&e()},0);else if(this.aceEditor&&this.curserInfoElements){var s=this.aceEditor.getCursorPosition(),a=this.aceEditor.getSelectedText();t=s.row+1,i=s.column+1,n=a.length,o.cursorInfo={line:t,column:i,count:n},this.options.statusBar&&e()}},s._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},s.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},s.compact=function(){var e=this.get(),t=JSON.stringify(e);this.setText(t)},s.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.setText(t)},s.repair=function(){var e=this.getText(),t=r.sanitize(e);this.setText(t)},s.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},s.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},s.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},s.get=function(){var e,t=this.getText();try{e=r.parse(t)}catch(i){t=r.sanitize(t),e=r.parse(t)}return e},s.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},s.setText=function(e){var t;if(t=!0===this.options.escapeUnicode?r.escapeUnicodeChars(e):e,this.textarea&&(this.textarea.value=t),this.aceEditor){var i=this.options.onChange;this.options.onChange=null,this.aceEditor.setValue(t,-1),this.options.onChange=i}this.validate()},s.validate=function(){this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.content.style.marginBottom="",this.content.style.paddingBottom="");var e,t=!1,i=[];try{e=this.get(),t=!0}catch(e){}if(t&&this.validateSchema){this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return r.improveSchemaError(e)}))}if(i.length>0){if(i.length>3){i=i.slice(0,3);var n=this.validateSchema.errors.length-3;i.push("("+n+" more errors...)")}var o=document.createElement("div");o.innerHTML='<table class="jsoneditor-text-errors"><tbody>'+i.map(function(e){return'<tr><td><button class="jsoneditor-schema-error"></button></td>'+("string"==typeof e?'<td colspan="2"><pre>'+e+"</pre></td>":"<td>"+e.dataPath+"</td><td>"+e.message+"</td>")+"</tr>"}).join("")+"</tbody></table>",this.dom.validationErrors=o,this.dom.validationErrorsContainer.appendChild(o);var s=o.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.content.style.marginBottom=-s+"px",this.content.style.paddingBottom=s+"px"}if(this.aceEditor){this.aceEditor.resize(!1)}},s.getTextSelection=function(){var e={};if(this.textarea){var t=r.getInputSelection(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),o=i.getRange(),s=i.getSelectionLead();return s.row===o.end.row&&s.column===o.end.column?e=o:(e.start=o.end,e.end=o.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},s.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=r.debounce(e,this.DEBOUNCE_INTERVAL))},s.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var i=r.getIndexForPosition(this.textarea,e.row,e.column),n=r.getIndexForPosition(this.textarea,t.row,t.column);if(i>-1&&n>-1)if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(i,n);else if(this.textarea.createTextRange){var o=this.textarea.createTextRange();o.collapse(!0),o.moveEnd("character",n),o.moveStart("character",i),o.select()}}else if(this.aceEditor){var o={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(o)}},e.exports=[{mode:"text",mixin:s,data:"text",load:s.format},{mode:"code",mixin:s,data:"text",load:s.format}]},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(!function(){var e=new Error('Cannot find module "brace"');throw e.code="MODULE_NOT_FOUND",e}()),i(23),i(25)}catch(e){}e.exports=n},function(e,t,i){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";var n=e("../lib/oop"),o=e("./text_highlight_rules").TextHighlightRules,r=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}};n.inherits(r,o),t.JsonHighlightRules=r}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range,o=function(){};(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t),o=i.match(/^(\s*\})/);if(!o)return 0;var r=o[1].length,s=e.findMatchingBracket({row:t,column:r});if(!s||s.row==t)return 0;var a=this.$getIndent(e.getLine(s.row));e.replace(new n(t,0,t,r-1),a)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(o.prototype),t.MatchingBraceOutdent=o}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),o=e("../../range").Range,r=e("./fold_mode").FoldMode,s=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(s,r),function(){
this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var o=this._getFoldWidgetBase(e,t,i);return!o&&this.startRegionRe.test(n)?"start":o},this.getFoldWidgetRange=function(e,t,i,n){var o=e.getLine(i);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,i);var r=o.match(this.foldingStartMarker);if(r){var s=r.index;if(r[1])return this.openingBracketBlock(e,r[1],i,s);var a=e.getCommentFoldRange(i,s+r[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t){var r=o.match(this.foldingStopMarker);if(r){var s=r.index+r[0].length;return r[1]?this.closingBracketBlock(e,r[1],i,s):e.getCommentFoldRange(i,s,-1)}}},this.getSectionRange=function(e,t){var i=e.getLine(t),n=i.search(/\S/),r=t,s=i.length;t+=1;for(var a=t,l=e.getLength();++t<l;){i=e.getLine(t);var c=i.search(/\S/);if(-1!==c){if(n>c)break;var h=this.getFoldWidgetRange(e,"all",t);if(h){if(h.start.row<=r)break;if(h.isMultiLine())t=h.end.row;else if(n==c)break}a=t}}return new o(r,s,a,e.getLine(a).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),r=e.getLength(),s=i,a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,l=1;++i<r;){t=e.getLine(i);var c=a.exec(t);if(c&&(c[1]?l--:l++,!l))break}var h=i;if(h>s)return new o(s,n,h,t.length)}}.call(s.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,n){"use strict";var o=e("../lib/oop"),r=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,h=e("../worker/worker_client").WorkerClient,d=function(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c};o.inherits(d,r),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);if("start"==e){t.match(/^.*[\{\(\[]\s*$/)&&(n+=i)}return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(e){var t=new h(["ace"],i(24),"JsonWorker");return t.attachToDocument(e.getDocument()),t.on("annotate",function(t){e.setAnnotations(t.data)}),t.on("terminate",function(){e.clearAnnotations()}),t},this.$id="ace/mode/json"}.call(d.prototype),t.Mode=d})},function(e,t){e.exports.id="ace/mode/json_worker",e.exports.src='"no use strict";!function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}}(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},function(e,t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var n=e("../lib/dom"),o=e("../lib/lang"),r=e("../lib/event"),s=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");n.importCssString('\t.ace_search {\tbackground-color: #ddd;\tcolor: #666;\tborder: 1px solid #cbcbcb;\tborder-top: 0 none;\toverflow: hidden;\tmargin: 0;\tpadding: 4px 6px 0 4px;\tposition: absolute;\ttop: 0;\tz-index: 99;\twhite-space: normal;\t}\t.ace_search.left {\tborder-left: 0 none;\tborder-radius: 0px 0px 5px 0px;\tleft: 0;\t}\t.ace_search.right {\tborder-radius: 0px 0px 0px 5px;\tborder-right: 0 none;\tright: 0;\t}\t.ace_search_form, .ace_replace_form {\tmargin: 0 20px 4px 0;\toverflow: hidden;\tline-height: 1.9;\t}\t.ace_replace_form {\tmargin-right: 0;\t}\t.ace_search_form.ace_nomatch {\toutline: 1px solid red;\t}\t.ace_search_field {\tborder-radius: 3px 0 0 3px;\tbackground-color: white;\tcolor: black;\tborder: 1px solid #cbcbcb;\tborder-right: 0 none;\tbox-sizing: border-box!important;\toutline: 0;\tpadding: 0;\tfont-size: inherit;\tmargin: 0;\tline-height: inherit;\tpadding: 0 6px;\tmin-width: 17em;\tvertical-align: top;\t}\t.ace_searchbtn {\tborder: 1px solid #cbcbcb;\tline-height: inherit;\tdisplay: inline-block;\tpadding: 0 6px;\tbackground: #fff;\tborder-right: 0 none;\tborder-left: 1px solid #dcdcdc;\tcursor: pointer;\tmargin: 0;\tposition: relative;\tbox-sizing: content-box!important;\tcolor: #666;\t}\t.ace_searchbtn:last-child {\tborder-radius: 0 3px 3px 0;\tborder-right: 1px solid #cbcbcb;\t}\t.ace_searchbtn:disabled {\tbackground: none;\tcursor: default;\t}\t.ace_searchbtn:hover {\tbackground-color: #eef1f6;\t}\t.ace_searchbtn.prev, .ace_searchbtn.next {\tpadding: 0px 0.7em\t}\t.ace_searchbtn.prev:after, .ace_searchbtn.next:after {\tcontent: "";\tborder: solid 2px #888;\twidth: 0.5em;\theight: 0.5em;\tborder-width:  2px 0 0 2px;\tdisplay:inline-block;\ttransform: rotate(-45deg);\t}\t.ace_searchbtn.next:after {\tborder-width: 0 2px 2px 0 ;\t}\t.ace_searchbtn_close {\tbackground: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;\tborder-radius: 50%;\tborder: 0 none;\tcolor: #656565;\tcursor: pointer;\tfont: 16px/16px Arial;\tpadding: 0;\theight: 14px;\twidth: 14px;\ttop: 9px;\tright: 7px;\tposition: absolute;\t}\t.ace_searchbtn_close:hover {\tbackground-color: #656565;\tbackground-position: 50% 100%;\tcolor: white;\t}\t.ace_button {\tmargin-left: 2px;\tcursor: pointer;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\toverflow: hidden;\topacity: 0.7;\tborder: 1px solid rgba(100,100,100,0.23);\tpadding: 1px;\tbox-sizing:    border-box!important;\tcolor: black;\t}\t.ace_button:hover {\tbackground-color: #eee;\topacity:1;\t}\t.ace_button:active {\tbackground-color: #ddd;\t}\t.ace_button.checked {\tborder-color: #3399ff;\topacity:1;\t}\t.ace_search_options{\tmargin-bottom: 3px;\ttext-align: right;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\tclear: both;\t}\t.ace_search_counter {\tfloat: left;\tfont-family: arial;\tpadding: 0 8px;\t}',"ace_searchbox");var l='<div class="ace_search right">\t    <span action="hide" class="ace_searchbtn_close"></span>\t    <div class="ace_search_form">\t        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>\t        <span action="findPrev" class="ace_searchbtn prev"></span>\t        <span action="findNext" class="ace_searchbtn next"></span>\t        <span action="findAll" class="ace_searchbtn" title="Alt-Enter">All</span>\t    </div>\t    <div class="ace_replace_form">\t        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>\t        <span action="replaceAndFindNext" class="ace_searchbtn">Replace</span>\t        <span action="replaceAll" class="ace_searchbtn">All</span>\t    </div>\t    <div class="ace_search_options">\t        <span action="toggleReplace" class="ace_button" title="Toggel Replace mode"\t            style="float:left;margin-top:-2px;padding:0 5px;">+</span>\t        <span class="ace_search_counter"></span>\t        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>\t        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>\t        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>\t        <span action="searchInSelection" class="ace_button" title="Search In Selection">S</span>\t    </div>\t</div>'.replace(/> +/g,">"),c=function(e,t,i){var o=n.createElement("div");o.innerHTML=l,this.element=o.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e)};(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var t=this;r.addListener(e,"mousedown",function(e){setTimeout(function(){t.activeInput.focus()},0),r.stopPropagation(e)}),r.addListener(e,"click",function(e){var i=e.target||e.srcElement,n=i.getAttribute("action");n&&t[n]?t[n]():t.$searchBarKb.commands[n]&&t.$searchBarKb.commands[n].exec(t),r.stopPropagation(e)}),r.addCommandKeyListener(e,function(e,i,n){var o=a.keyCodeToString(n),s=t.$searchBarKb.findKeyCommand(i,o);s&&s.exec&&(s.exec(t),r.stopEvent(e))}),this.$onChange=o.delayedCall(function(){t.find(!1,!1)}),r.addListener(this.searchInput,"input",function(){t.$onChange.schedule(20)}),r.addListener(this.searchInput,"focus",function(){t.activeInput=t.searchInput,t.searchInput.value&&t.highlight()}),r.addListener(this.replaceInput,"focus",function(){t.activeInput=t.replaceInput,t.searchInput.value&&t.highlight()})},this.$closeSearchBarKb=new s([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new s,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){this.searchRange=e,e?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){n.setCssClass(this.replaceOption,"checked",this.searchRange),n.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",n.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),n.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),n.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.replaceBox.style.display=this.replaceOption.checked?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var o=this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange}),r=!o&&this.searchInput.value;n.setCssClass(this.searchBox,"ace_nomatch",r),this.editor._emit("findSearchBox",{match:!r}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var o=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),r=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(r-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(o))&&(i++,a=s.index,a<=r&&n++,!(i>999))&&(s[0]||(t.lastIndex=a+=1,!(a>=o.length))););}this.searchCounter.textContent=n+" of "+(i>999?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked}),t=!e&&this.searchInput.value;n.setCssClass(this.searchBox,"ace_nomatch",t),this.editor._emit("findSearchBox",{match:!t}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}}),function(){ace.acequire(["ace/ext/searchbox"],function(){})}()},function(e,t){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\tbackground: #ebebeb;\tcolor: #333\t}\t\t.ace-jsoneditor.ace_editor {\tfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\tline-height: 1.3;\tbackground-color: #fff;\t}\t.ace-jsoneditor .ace_print-margin {\twidth: 1px;\tbackground: #e8e8e8\t}\t.ace-jsoneditor .ace_scroller {\tbackground-color: #FFFFFF\t}\t.ace-jsoneditor .ace_text-layer {\tcolor: gray\t}\t.ace-jsoneditor .ace_variable {\tcolor: #1a1a1a\t}\t.ace-jsoneditor .ace_cursor {\tborder-left: 2px solid #000000\t}\t.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\tborder-left: 0px;\tborder-bottom: 1px solid #000000\t}\t.ace-jsoneditor .ace_marker-layer .ace_selection {\tbackground: lightgray\t}\t.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\tbox-shadow: 0 0 3px 0px #FFFFFF;\tborder-radius: 2px\t}\t.ace-jsoneditor .ace_marker-layer .ace_step {\tbackground: rgb(255, 255, 0)\t}\t.ace-jsoneditor .ace_marker-layer .ace_bracket {\tmargin: -1px 0 0 -1px;\tborder: 1px solid #BFBFBF\t}\t.ace-jsoneditor .ace_marker-layer .ace_active-line {\tbackground: #FFFBD1\t}\t.ace-jsoneditor .ace_gutter-active-line {\tbackground-color : #dcdcdc\t}\t.ace-jsoneditor .ace_marker-layer .ace_selected-word {\tborder: 1px solid lightgray\t}\t.ace-jsoneditor .ace_invisible {\tcolor: #BFBFBF\t}\t.ace-jsoneditor .ace_keyword,\t.ace-jsoneditor .ace_meta,\t.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\tcolor: #AF956F\t}\t.ace-jsoneditor .ace_keyword.ace_operator {\tcolor: #484848\t}\t.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\tcolor: #96DC5F\t}\t.ace-jsoneditor .ace_constant.ace_language {\tcolor: darkorange\t}\t.ace-jsoneditor .ace_constant.ace_numeric {\tcolor: red\t}\t.ace-jsoneditor .ace_constant.ace_character.ace_entity {\tcolor: #BF78CC\t}\t.ace-jsoneditor .ace_invalid {\tcolor: #FFFFFF;\tbackground-color: #FF002A;\t}\t.ace-jsoneditor .ace_fold {\tbackground-color: #AF956F;\tborder-color: #000000\t}\t.ace-jsoneditor .ace_storage,\t.ace-jsoneditor .ace_support.ace_class,\t.ace-jsoneditor .ace_support.ace_function,\t.ace-jsoneditor .ace_support.ace_other,\t.ace-jsoneditor .ace_support.ace_type {\tcolor: #C52727\t}\t.ace-jsoneditor .ace_string {\tcolor: green\t}\t.ace-jsoneditor .ace_comment {\tcolor: #BCC8BA\t}\t.ace-jsoneditor .ace_entity.ace_name.ace_tag,\t.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\tcolor: #606060\t}\t.ace-jsoneditor .ace_markup.ace_underline {\ttext-decoration: underline\t}\t.ace-jsoneditor .ace_indent-guide {\tbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\t}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})}])});
//# sourceMappingURL=jsoneditor-minimalist.map