"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Stylist = function () {
  function Stylist() {
    var _this = this;

    _classCallCheck(this, Stylist);

    this.toolboxVisible = true;

    this.DEFAULT_PERCENTAGE = 0.6;
    this.TOOLBAR_HEIGHT = 64;
    this.TOOLBOX_HEIGHT = 156;
    this.TOOLBAR_AND_TOOLBOX_HEIGHT = function () {
      return _this.TOOLBAR_HEIGHT + (_this.toolboxVisible ? _this.TOOLBOX_HEIGHT : 0);
    };
    this.CELL_SIZE = 59;
    this.BOARD_CSS_CLASS = ".theBoard";
    this.BOARD_CONTAINER_CSS_CLASS = ".theBoardContainer";
    this.BOARD_CONTAINER_OFFSET = 8;
    this.BOARD_CONTAINER_VERTICAL_MARGIN = 50;
    this.LEFT_PANEL_CSS_CLASS = ".panel-left";
  }

  _createClass(Stylist, [{
    key: "correctEditorHeight",
    value: function correctEditorHeight(editor) {
      var lineHeight = editor.renderer.lineHeight;
      var availableLines = ($(document).height() - this.TOOLBAR_HEIGHT) / editor.renderer.lineHeight;

      editor.setOption("minLines", availableLines);
      editor.setOption("maxLines", availableLines);
    }
  }, {
    key: "setPanelAsResizable",
    value: function setPanelAsResizable(boardDimensions) {
      var _this2 = this;

      $(document).ready(function () {
        _this2._makeResizable();
        setTimeout(function () {
          $(_this2.LEFT_PANEL_CSS_CLASS + " .ui-resizable-s").hide();
          $(_this2.LEFT_PANEL_CSS_CLASS + " .ui-resizable-se").hide();

          _this2.updateBoardSize(boardDimensions);
        }, 0);
      });

      $(window).resize(function () {
        _this2._beResponsive();
      });
    }
  }, {
    key: "updateBoardSize",
    value: function updateBoardSize(boardDimensions) {
      this._saveBoardSize(boardDimensions);
      this._beResponsive();
    }
  }, {
    key: "setBlocklyResize",
    value: function setBlocklyResize() {
      var _this3 = this;

      var resize = function resize() {
        var panel = $(_this3.LEFT_PANEL_CSS_CLASS);
        $("#blocklyDiv").css("width", panel.width() + "px");
        $("#blocklyDiv").css("height", panel.height() - _this3.TOOLBAR_HEIGHT + "px");
      };

      setTimeout(resize, 0);
      $(window).resize(resize);
    }
  }, {
    key: "_beResponsive",
    value: function _beResponsive() {
      var percentage = this._keepAspectRatioOnWindowResize(this.LEFT_PANEL_CSS_CLASS);
      this._scaleAndCenterBoard(percentage);
    }
  }, {
    key: "_keepAspectRatioOnWindowResize",
    value: function _keepAspectRatioOnWindowResize() {
      var documentWidth = $(document).width();
      if (!this.lastDocumentWidth) {
        this.lastDocumentWidth = documentWidth;
        return this.DEFAULT_PERCENTAGE;
      }

      var percentage = this._getPercentage();

      var leftPanel = $(this.LEFT_PANEL_CSS_CLASS);
      leftPanel.width(documentWidth * percentage);
      this.lastDocumentWidth = documentWidth;

      return percentage;
    }
  }, {
    key: "_scaleAndCenterBoard",
    value: function _scaleAndCenterBoard(percentage) {
      var scale = this._getScale(percentage);
      $(this.BOARD_CSS_CLASS).css("transform", "scale(" + scale + ")");
      this._centerBoard(percentage, scale);
    }
  }, {
    key: "_centerBoard",
    value: function _centerBoard(percentage, scale) {
      var _this4 = this;

      var applyMargin = function applyMargin(x, m, b) {
        return -(m * x + b) * _this4.CELL_SIZE * scale;
      };

      // center vertically
      var middleY = this._getRightPanelHeight() / 2;
      var offsetY = this.currentBoardHeight / 2 + applyMargin(this.boardDimensions.y, 0.111561862, -0.111561862);
      $(this.BOARD_CSS_CLASS).css("margin-top", middleY - offsetY + "px");

      // center horizontally
      $(".theBoardContainer").width(0); // avoid increasing container width
      var panelWidth = this._getRightPanelWidth(percentage);
      var middleX = panelWidth / 2;
      var offsetX = this.BOARD_CONTAINER_OFFSET + this.currentBoardWidth * scale / 2 + applyMargin(this.boardDimensions.x, -0.000975862, 0.131475862);

      $(this.BOARD_CONTAINER_CSS_CLASS).css("margin-left", middleX - offsetX + "px");
    }
  }, {
    key: "_makeResizable",
    value: function _makeResizable() {
      $(this.LEFT_PANEL_CSS_CLASS).resizable({
        resizeHeight: false
      });
    }
  }, {
    key: "_saveBoardSize",
    value: function _saveBoardSize(boardDimensions) {
      var boardSize = this._getBoardSize(boardDimensions);
      this.currentBoardWidth = boardSize.width;
      this.currentBoardHeight = boardSize.height;
      this.boardDimensions = boardDimensions;
    }
  }, {
    key: "_getBoardSize",
    value: function _getBoardSize(boardDimensions) {
      return {
        width: 39 + boardDimensions.x * this.CELL_SIZE,
        height: 39 + boardDimensions.y * this.CELL_SIZE
      };
    }
  }, {
    key: "_getPercentage",
    value: function _getPercentage() {
      var leftPanel = $(this.LEFT_PANEL_CSS_CLASS);
      return leftPanel.width() / this.lastDocumentWidth;
    }
  }, {
    key: "_getRightPanelWidth",
    value: function _getRightPanelWidth(percentage) {
      return $(document).width() * (1 - percentage);
    }
  }, {
    key: "_getRightPanelHeight",
    value: function _getRightPanelHeight() {
      return $(document).height() - this.TOOLBAR_AND_TOOLBOX_HEIGHT() - this.BOARD_CONTAINER_VERTICAL_MARGIN;
    }
  }, {
    key: "_getScale",
    value: function _getScale(percentage) {
      var panelWidth = this._getRightPanelWidth(percentage);
      var scaleX = panelWidth / this.currentBoardWidth;

      var panelHeight = this._getRightPanelHeight();
      var scaleY = panelHeight / this.currentBoardHeight;

      return Math.max(Math.min(scaleX, scaleY), 0);
    }
  }]);

  return Stylist;
}();

;