"use strict";

// http://stackoverflow.com/questions/901115/how-can-i-get-query-string-values-in-javascript
function getParameterByName(name, url) {
  if (!url) url = window.location.href;
  name = name.replace(/[\[\]]/g, "\\$&");
  var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
      results = regex.exec(url);
  if (!results) return null;
  if (!results[2]) return '';
  return decodeURIComponent(results[2].replace(/\+/g, " "));
}

Polymer({
  is: 'gobstones-ide',
  listeners: {
    "show-code-changed": "_showCodeChanged",
    "show-boards-changed": "_showBoardsChanged"
  },
  behaviors: [Polymer.LocalizationBehavior, Polymer.LoaderBehavior],
  properties: {
    projectType: String,
    isLoading: {
      type: Boolean,
      value: false
    }
  },

  ready: function ready() {
    this._setUpLoaders();
  },

  isBlocksProject: function isBlocksProject(projectType) {
    return projectType === 'blocks';
  },
  isCodeProject: function isCodeProject(projectType) {
    return projectType === 'code';
  },

  buttonCssClass: function buttonCssClass(show) {
    return !show ? "button-disabled" : "";
  },

  _showCodeChanged: function _showCodeChanged(_ref) {
    var detail = _ref.detail;

    this._resizeLeftPanel(detail, 0);
  },

  _showBoardsChanged: function _showBoardsChanged(_ref2) {
    var detail = _ref2.detail;

    this._resizeLeftPanel(detail, $(document).width());
  },

  _resizeLeftPanel: function _resizeLeftPanel(show, size) {
    $(".panel-left").width(show ? $(document).width() * 0.6 : size);
    $(window).trigger("resize");
  },

  _setUpLoaders: function _setUpLoaders() {
    var getContext = this._context.bind(this);

    var projectUrl = getParameterByName("url");
    if (projectUrl) return this._setUpLoader(UrlLoader, projectUrl, getContext);

    var gitHubSlug = getParameterByName("github");
    if (gitHubSlug) return this._setUpLoader(GitHubLoader, gitHubSlug, getContext);
  },

  _setUpLoader: function _setUpLoader(Loader, url, getContext) {
    var _this = this;

    window.LOAD_PENDING_PROJECT = function () {
      _this.isLoading = true;

      new Loader(_this.projectType).load(url, getContext).catch(function (e) {
        console.error(e);
        alert(_this.localize("error-loading-project"));
      }).always(function () {
        _this.isLoading = false;
      });
    };
  }
});